/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.discordipc.entities;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jagrosh.discordipc.entities.ActivityType;
import com.jagrosh.discordipc.entities.PartyPrivacy;
import com.jagrosh.discordipc.entities.StatusDisplayType;
import java.util.Objects;

public class RichPresence {
    private static final int MIN_ALLOWED_BUTTONS = 1;
    private static final int MAX_ALLOWED_BUTTONS = 2;
    private final ActivityType activityType;
    private final StatusDisplayType statusDisplayType;
    private final String state;
    private final String stateUrl;
    private final String details;
    private final String detailsUrl;
    private final String name;
    private final long startTimestamp;
    private final long endTimestamp;
    private final String largeImageKey;
    private final String largeImageText;
    private final String largeImageUrl;
    private final String smallImageKey;
    private final String smallImageText;
    private final String smallImageUrl;
    private final String partyId;
    private final int partySize;
    private final int partyMax;
    private final PartyPrivacy partyPrivacy;
    private final String matchSecret;
    private final String joinSecret;
    private final String spectateSecret;
    private final JsonArray buttons;
    private final boolean instance;

    public RichPresence(ActivityType activityType, StatusDisplayType statusDisplayType, String state, String stateUrl, String details, String detailsUrl, String name, long startTimestamp, long endTimestamp, String largeImageKey, String largeImageText, String largeImageUrl, String smallImageKey, String smallImageText, String smallImageUrl, String partyId, int partySize, int partyMax, PartyPrivacy partyPrivacy, String matchSecret, String joinSecret, String spectateSecret, JsonArray buttons, boolean instance) {
        this.activityType = activityType;
        this.statusDisplayType = statusDisplayType;
        this.state = state;
        this.stateUrl = stateUrl;
        this.details = details;
        this.detailsUrl = detailsUrl;
        this.name = name;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.largeImageKey = largeImageKey;
        this.largeImageText = largeImageText;
        this.largeImageUrl = largeImageUrl;
        this.smallImageKey = smallImageKey;
        this.smallImageText = smallImageText;
        this.smallImageUrl = smallImageUrl;
        this.partyId = partyId;
        this.partySize = partySize;
        this.partyMax = partyMax;
        this.partyPrivacy = partyPrivacy;
        this.matchSecret = matchSecret;
        this.joinSecret = joinSecret;
        this.spectateSecret = spectateSecret;
        this.buttons = buttons;
        this.instance = instance;
    }

    public JsonObject toJson() {
        JsonObject timestamps = new JsonObject();
        JsonObject assets = new JsonObject();
        JsonObject party = new JsonObject();
        JsonObject secrets = new JsonObject();
        JsonObject finalObject = new JsonObject();
        if (this.startTimestamp > 0L) {
            timestamps.addProperty("start", this.startTimestamp);
            if (this.endTimestamp > this.startTimestamp) {
                timestamps.addProperty("end", this.endTimestamp);
            }
        }
        if (this.largeImageKey != null && !this.largeImageKey.isEmpty()) {
            assets.addProperty("large_image", this.largeImageKey);
            if (this.largeImageText != null && !this.largeImageText.isEmpty()) {
                assets.addProperty("large_text", this.largeImageText);
            }
            if (this.largeImageUrl != null && !this.largeImageUrl.isEmpty()) {
                assets.addProperty("large_url", this.largeImageUrl);
            }
        }
        if (this.smallImageKey != null && !this.smallImageKey.isEmpty()) {
            assets.addProperty("small_image", this.smallImageKey);
            if (this.smallImageText != null && !this.smallImageText.isEmpty()) {
                assets.addProperty("small_text", this.smallImageText);
            }
            if (this.smallImageUrl != null && !this.smallImageUrl.isEmpty()) {
                assets.addProperty("small_url", this.smallImageUrl);
            }
        }
        if (this.partyId != null && !this.partyId.isEmpty() || this.partySize > 0 && this.partyMax > 0) {
            if (this.partyId != null && !this.partyId.isEmpty()) {
                party.addProperty("id", this.partyId);
            }
            JsonArray partyData = new JsonArray();
            if (this.partySize > 0) {
                partyData.add(new JsonPrimitive(this.partySize));
                if (this.partyMax >= this.partySize) {
                    partyData.add(new JsonPrimitive(this.partyMax));
                }
            }
            party.add("size", partyData);
            party.add("privacy", new JsonPrimitive(this.partyPrivacy.ordinal()));
        }
        if (this.joinSecret != null && !this.joinSecret.isEmpty()) {
            secrets.addProperty("join", this.joinSecret);
        }
        if (this.spectateSecret != null && !this.spectateSecret.isEmpty()) {
            secrets.addProperty("spectate", this.spectateSecret);
        }
        if (this.matchSecret != null && !this.matchSecret.isEmpty()) {
            secrets.addProperty("match", this.matchSecret);
        }
        finalObject.addProperty("type", this.activityType.ordinal());
        finalObject.addProperty("status_display_type", this.statusDisplayType.ordinal());
        if (this.state != null && !this.state.isEmpty()) {
            finalObject.addProperty("state", this.state);
            if (this.stateUrl != null && !this.stateUrl.isEmpty()) {
                finalObject.addProperty("state_url", this.stateUrl);
            }
        }
        if (this.details != null && !this.details.isEmpty()) {
            finalObject.addProperty("details", this.details);
            if (this.detailsUrl != null && !this.detailsUrl.isEmpty()) {
                finalObject.addProperty("details_url", this.detailsUrl);
            }
        }
        if (this.name != null && !this.name.isEmpty()) {
            finalObject.addProperty("name", this.name);
        }
        if (timestamps.has("start")) {
            finalObject.add("timestamps", timestamps);
        }
        if (assets.has("large_image")) {
            finalObject.add("assets", assets);
        }
        if (party.has("id")) {
            finalObject.add("party", party);
        }
        if (secrets.has("join") || secrets.has("spectate") || secrets.has("match")) {
            finalObject.add("secrets", secrets);
        }
        if (this.buttons != null && !this.buttons.isJsonNull() && this.buttons.size() >= 1 && this.buttons.size() <= 2) {
            finalObject.add("buttons", this.buttons);
        }
        finalObject.addProperty("instance", this.instance);
        return finalObject;
    }

    public String toDecodedJson(String encoding) {
        try {
            return new String(this.toJson().toString().getBytes(encoding));
        }
        catch (Exception ex) {
            return this.toJson().toString();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof RichPresence)) {
            return false;
        }
        RichPresence oPresence = (RichPresence)o;
        return this == oPresence || Objects.equals((Object)this.activityType, (Object)oPresence.activityType) && Objects.equals((Object)this.statusDisplayType, (Object)oPresence.statusDisplayType) && Objects.equals(this.state, oPresence.state) && Objects.equals(this.stateUrl, oPresence.stateUrl) && Objects.equals(this.details, oPresence.details) && Objects.equals(this.detailsUrl, oPresence.detailsUrl) && Objects.equals(this.name, oPresence.name) && Objects.equals(this.startTimestamp, oPresence.startTimestamp) && Objects.equals(this.endTimestamp, oPresence.endTimestamp) && Objects.equals(this.largeImageKey, oPresence.largeImageKey) && Objects.equals(this.largeImageText, oPresence.largeImageText) && Objects.equals(this.largeImageUrl, oPresence.largeImageUrl) && Objects.equals(this.smallImageKey, oPresence.smallImageKey) && Objects.equals(this.smallImageText, oPresence.smallImageText) && Objects.equals(this.smallImageUrl, oPresence.smallImageUrl) && Objects.equals(this.partyId, oPresence.partyId) && Objects.equals(this.partySize, oPresence.partySize) && Objects.equals(this.partyMax, oPresence.partyMax) && Objects.equals((Object)this.partyPrivacy, (Object)oPresence.partyPrivacy) && Objects.equals(this.matchSecret, oPresence.matchSecret) && Objects.equals(this.joinSecret, oPresence.joinSecret) && Objects.equals(this.spectateSecret, oPresence.spectateSecret) && Objects.equals(this.buttons, oPresence.buttons) && Objects.equals(this.instance, oPresence.instance);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activityType, this.statusDisplayType, this.state, this.stateUrl, this.details, this.detailsUrl, this.name, this.startTimestamp, this.endTimestamp, this.largeImageKey, this.largeImageText, this.largeImageUrl, this.smallImageKey, this.smallImageText, this.smallImageUrl, this.partyId, this.partySize, this.partyMax, this.partyPrivacy, this.matchSecret, this.joinSecret, this.spectateSecret, this.buttons, this.instance});
    }

    public static class Builder {
        private ActivityType activityType;
        private StatusDisplayType statusDisplayType;
        private String state;
        private String stateUrl;
        private String details;
        private String detailsUrl;
        private String name;
        private long startTimestamp;
        private long endTimestamp;
        private String largeImageKey;
        private String largeImageText;
        private String largeImageUrl;
        private String smallImageKey;
        private String smallImageText;
        private String smallImageUrl;
        private String partyId;
        private int partySize;
        private int partyMax;
        private PartyPrivacy partyPrivacy;
        private String matchSecret;
        private String joinSecret;
        private String spectateSecret;
        private JsonArray buttons;
        private boolean instance;

        public RichPresence build() {
            return new RichPresence(this.activityType, this.statusDisplayType, this.state, this.stateUrl, this.details, this.detailsUrl, this.name, this.startTimestamp, this.endTimestamp, this.largeImageKey, this.largeImageText, this.largeImageUrl, this.smallImageKey, this.smallImageText, this.smallImageUrl, this.partyId, this.partySize, this.partyMax, this.partyPrivacy, this.matchSecret, this.joinSecret, this.spectateSecret, this.buttons, this.instance);
        }

        public Builder setActivityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public Builder setStatusDisplayType(StatusDisplayType statusDisplayType) {
            this.statusDisplayType = statusDisplayType;
            return this;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public Builder setStateUrl(String stateUrl) {
            this.stateUrl = stateUrl;
            return this;
        }

        public Builder setDetails(String details) {
            this.details = details;
            return this;
        }

        public Builder setDetailsUrl(String detailsUrl) {
            this.detailsUrl = detailsUrl;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setStartTimestamp(long startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public Builder setEndTimestamp(long endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public Builder setLargeImage(String largeImageKey, String largeImageText, String largeImageUrl) {
            this.largeImageKey = largeImageKey;
            this.largeImageText = largeImageText;
            this.largeImageUrl = largeImageUrl;
            return this;
        }

        public Builder setLargeImageWithTooltip(String largeImageKey, String largeImageText) {
            return this.setLargeImage(largeImageKey, largeImageText, null);
        }

        public Builder setLargeImageWithUrl(String largeImageKey, String largeImageUrl) {
            return this.setLargeImage(largeImageKey, null, largeImageUrl);
        }

        public Builder setLargeImage(String largeImageKey) {
            return this.setLargeImage(largeImageKey, null, null);
        }

        public Builder setSmallImage(String smallImageKey, String smallImageText, String smallImageUrl) {
            this.smallImageKey = smallImageKey;
            this.smallImageText = smallImageText;
            this.smallImageUrl = smallImageUrl;
            return this;
        }

        public Builder setSmallImageWithTooltip(String smallImageKey, String smallImageText) {
            return this.setSmallImage(smallImageKey, smallImageText, null);
        }

        public Builder setSmallImageWithUrl(String smallImageKey, String smallImageUrl) {
            return this.setSmallImage(smallImageKey, null, smallImageUrl);
        }

        public Builder setSmallImage(String smallImageKey) {
            return this.setSmallImage(smallImageKey, null, null);
        }

        public Builder setParty(String partyId, int partySize, int partyMax, PartyPrivacy partyPrivacy) {
            this.partyId = partyId;
            this.partySize = partySize;
            this.partyMax = partyMax;
            this.partyPrivacy = partyPrivacy;
            return this;
        }

        public Builder setMatchSecret(String matchSecret) {
            this.matchSecret = matchSecret;
            return this;
        }

        public Builder setJoinSecret(String joinSecret) {
            this.joinSecret = joinSecret;
            return this;
        }

        public Builder setSpectateSecret(String spectateSecret) {
            this.spectateSecret = spectateSecret;
            return this;
        }

        public Builder setButtons(JsonArray buttons) {
            this.buttons = buttons;
            return this;
        }

        public Builder setInstance(boolean instance) {
            this.instance = instance;
            return this;
        }
    }
}

