/*
 * Decompiled with CFR 0.152.
 */
package com.teunjojo;

import com.teunjojo.RestartScheduler;
import com.teunjojo.SimpleAutoRestart;
import com.teunjojo.Utility;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class CommandMain
implements TabExecutor {
    private SimpleAutoRestart plugin;
    private final RestartScheduler restartScheduler;
    private final Utility util = new Utility();

    public CommandMain(SimpleAutoRestart plugin) {
        this.plugin = plugin;
        this.restartScheduler = plugin.getRestartScheduler();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        switch (args[0]) {
            case "cancel": {
                return this.commandCancelRestart(sender);
            }
            case "resume": {
                return this.commandResumeRestart(sender);
            }
            case "status": {
                return this.commandStatus(sender);
            }
            case "set": {
                if (!this.commandSetRestart(sender, args)) {
                    sender.sendMessage("Usage: /" + label + " set <hour> <minute> [day]");
                }
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        block21: {
            if (!(sender instanceof Player)) break block21;
            ArrayList<String> completions = new ArrayList<String>();
            block6 : switch (args[0]) {
                case "set": {
                    switch (args.length) {
                        case 2: {
                            int i = 0;
                            while (i < 24) {
                                completions.add(String.valueOf(i));
                                ++i;
                            }
                            break block6;
                        }
                        case 3: {
                            int i = 0;
                            while (i < 60) {
                                completions.add(String.valueOf(i));
                                ++i;
                            }
                            break block6;
                        }
                        case 4: {
                            completions.add("Daily");
                            completions.add("Monday");
                            completions.add("Tuesday");
                            completions.add("Wednesday");
                            completions.add("Thursday");
                            completions.add("Friday");
                            completions.add("Saturday");
                            completions.add("Sunday");
                            break;
                        }
                    }
                    break;
                }
                default: {
                    completions.add("cancel");
                    completions.add("resume");
                    completions.add("status");
                    completions.add("set");
                }
                case "cancel": 
                case "resume": 
                case "status": 
            }
            return completions;
        }
        return null;
    }

    private boolean commandCancelRestart(CommandSender sender) {
        if (this.restartScheduler.isRestartCanceled()) {
            sender.sendMessage("Next auto restart is already canceled");
            return true;
        }
        sender.sendMessage("Next auto restart is canceled");
        this.restartScheduler.setRestartCanceled(true);
        return true;
    }

    private boolean commandResumeRestart(CommandSender sender) {
        if (!this.restartScheduler.isRestartCanceled()) {
            sender.sendMessage("Next auto restart is already scheduled");
            return true;
        }
        sender.sendMessage("Next auto restart resumed");
        this.restartScheduler.setRestartCanceled(false);
        return true;
    }

    private boolean commandStatus(CommandSender sender) {
        if (this.restartScheduler.isRestartCanceled()) {
            sender.sendMessage("Next auto restart is canceled");
        } else {
            sender.sendMessage("Next auto restart is scheduled");
        }
        return true;
    }

    private boolean commandSetRestart(CommandSender sender, String[] args) {
        String day = "Daily";
        int hour = -1;
        int minute = -1;
        if (args.length < 3) {
            sender.sendMessage(ChatColor.RED + "Not enough arguments!");
            return false;
        }
        if (args.length >= 4) {
            day = args[3];
        }
        try {
            hour = Integer.parseInt(args[1]);
            minute = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + "Hour and minute must be numbers!");
            return false;
        }
        if (this.util.weekDayToInt(day) == -1) {
            sender.sendMessage(ChatColor.RED + "Invalid day! Use Daily, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday or Sunday.");
            return false;
        }
        String _restartTime = String.valueOf(day) + ";" + String.format("%02d", hour) + ":" + String.format("%02d", minute);
        boolean success = this.restartScheduler.scheduleRestart(_restartTime, this.plugin.getMessages(), this.plugin.getTitles(), this.plugin.getSubtitles(), this.plugin.getCommands());
        if (!success) {
            sender.sendMessage(ChatColor.RED + "Invalid time format!");
            return false;
        }
        sender.sendMessage("Auto restart is scheduled at " + _restartTime);
        sender.sendMessage(ChatColor.YELLOW + "Note that this scheduled time is not saved and will be reset on server restart.");
        this.restartScheduler.setRestartCanceled(false);
        return true;
    }
}

