/*
 * Decompiled with CFR 0.152.
 */
package com.teunjojo;

import com.teunjojo.SimpleAutoRestart;
import com.teunjojo.Utility;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class RestartScheduler {
    private final SimpleAutoRestart plugin;
    private boolean restartCanceled = false;
    private final Utility util = new Utility();

    public RestartScheduler(SimpleAutoRestart plugin) {
        this.plugin = plugin;
    }

    public boolean scheduleRestart(String _restartTime, final Map<Long, String> _messages, final Map<Long, String> _titles, final Map<Long, String> _subtitles, final List<String> _commands) {
        if (_restartTime.matches("^([01]\\d|2[0-3]):([0-5]\\d)$")) {
            _restartTime = "Daily;" + _restartTime;
        }
        String[] parts = _restartTime.split(";");
        String dayPart = parts[0];
        String timePart = parts[1];
        int hour = Integer.parseInt(timePart.split(":")[0]);
        int minute = Integer.parseInt(timePart.split(":")[1]);
        ZonedDateTime now = ZonedDateTime.now();
        int currentDayOfWeek = now.getDayOfWeek().getValue();
        int targetDayOfWeek = this.util.weekDayToInt(dayPart);
        if (hour < 0 || hour > 23 || minute < 0 || minute > 59) {
            return false;
        }
        if (targetDayOfWeek == -1) {
            return false;
        }
        ZonedDateTime nextRestart = now.withHour(hour).withMinute(minute).withSecond(0);
        int daysUntilTarget = 0;
        if (targetDayOfWeek == 0) {
            if (nextRestart.isBefore(now)) {
                daysUntilTarget = 1;
            }
        } else {
            daysUntilTarget = (targetDayOfWeek - currentDayOfWeek + 7) % 7;
            if (nextRestart.isBefore(now)) {
                daysUntilTarget = 7;
            }
        }
        nextRestart = nextRestart.plusDays(daysUntilTarget);
        Duration duration = Duration.between(now, nextRestart);
        long initialDelayInSeconds = duration.getSeconds();
        Timer timer = new Timer();
        for (final Long delay : _messages.keySet()) {
            if (delay > initialDelayInSeconds) continue;
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!RestartScheduler.this.isRestartCanceled()) {
                        Bukkit.broadcastMessage((String)((String)_messages.get(delay)));
                    }
                }
            }, (initialDelayInSeconds - delay) * 1000L);
        }
        for (final Long delay : _titles.keySet()) {
            if (delay > initialDelayInSeconds) continue;
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!RestartScheduler.this.isRestartCanceled()) {
                        Bukkit.getOnlinePlayers().forEach(player -> player.sendTitle((String)_titles.get(delay), null, 10, 70, 20));
                    }
                }
            }, (initialDelayInSeconds - delay) * 1000L);
        }
        for (final Long delay : _subtitles.keySet()) {
            if (delay > initialDelayInSeconds) continue;
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!RestartScheduler.this.isRestartCanceled()) {
                        Bukkit.getOnlinePlayers().forEach(player -> player.sendTitle(null, (String)_subtitles.get(delay), 10, 70, 20));
                    }
                }
            }, (initialDelayInSeconds - delay) * 1000L);
        }
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!RestartScheduler.this.isRestartCanceled()) {
                    _commands.forEach(command -> Bukkit.getScheduler().runTask((Plugin)RestartScheduler.this.plugin, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command)));
                }
            }
        }, initialDelayInSeconds * 1000L);
        this.plugin.getLogger().info("Reboot set for: " + _restartTime);
        return true;
    }

    public boolean isRestartCanceled() {
        return this.restartCanceled;
    }

    public void setRestartCanceled(boolean restartCanceled) {
        this.restartCanceled = restartCanceled;
    }
}

