/*
 * Decompiled with CFR 0.152.
 */
package com.teunjojo;

import com.teunjojo.RestartScheduler;
import com.teunjojo.SimpleAutoRestart;
import com.teunjojo.Utility;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class CommandMain
implements TabExecutor {
    private SimpleAutoRestart plugin;
    private final RestartScheduler restartScheduler;
    private final Utility util = new Utility();
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEEE - HH:mm");

    public CommandMain(SimpleAutoRestart plugin) {
        this.plugin = plugin;
        this.restartScheduler = plugin.getRestartScheduler();
    }

    public boolean onCommand(CommandSender _sender, Command command, String label, String[] args) {
        Audience sender = this.plugin.adventure().sender(_sender);
        if (args.length == 0) {
            return false;
        }
        switch (args[0]) {
            case "cancel": {
                return this.commandCancelRestart(sender);
            }
            case "resume": {
                return this.commandResumeRestart(sender);
            }
            case "status": {
                return this.commandStatus(sender);
            }
            case "set": {
                if (!this.commandSetRestart(sender, args)) {
                    sender.sendMessage((Component)this.mm.deserialize("Usage: /" + label + " set <hour> <minute> [day]"));
                }
                return true;
            }
            case "reload": {
                return this.commandReload(sender);
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        block16: {
            if (!(sender instanceof Player)) break block16;
            ArrayList<String> completions = new ArrayList<String>();
            switch (args[0]) {
                case "set": {
                    completions.addAll(this.tabCompleteDate(args, 1));
                    break;
                }
                default: {
                    completions.add("cancel");
                    completions.add("resume");
                    completions.add("status");
                    completions.add("set");
                    completions.add("reload");
                }
                case "cancel": 
                case "reload": 
                case "resume": 
                case "status": 
            }
            return completions;
        }
        return null;
    }

    private boolean commandCancelRestart(Audience sender) {
        ZonedDateTime restart = this.restartScheduler.getNextRestart();
        if (this.restartScheduler.isRestartCanceled(restart)) {
            sender.sendMessage((Component)this.mm.deserialize("<red>Next auto restart is already canceled"));
            return true;
        }
        String formattedString = restart.format(this.formatter);
        this.restartScheduler.cancelRestart(restart);
        sender.sendMessage((Component)this.mm.deserialize("Restart for " + formattedString + " is canceled"));
        return true;
    }

    private boolean commandResumeRestart(Audience sender) {
        ZonedDateTime restart = this.restartScheduler.getNextRestart();
        if (!this.restartScheduler.isRestartCanceled(restart)) {
            sender.sendMessage((Component)this.mm.deserialize("<red>Next auto restart is not canceled"));
            return true;
        }
        String formattedString = restart.format(this.formatter);
        this.restartScheduler.resumeRestart(restart);
        sender.sendMessage((Component)this.mm.deserialize("Restart for " + formattedString + " is resumed"));
        return true;
    }

    private boolean commandStatus(Audience sender) {
        HashSet<ZonedDateTime> allRestarts = new HashSet<ZonedDateTime>();
        allRestarts.addAll(this.restartScheduler.getScheduledRestarts());
        allRestarts.addAll(this.restartScheduler.getCanceledRestarts());
        if (allRestarts.isEmpty()) {
            sender.sendMessage((Component)this.mm.deserialize("No restarts are scheduled."));
            return true;
        }
        ArrayList sortedRestarts = new ArrayList(allRestarts);
        sortedRestarts.sort(ChronoZonedDateTime::compareTo);
        boolean scheduledReached = false;
        sender.sendMessage((Component)this.mm.deserialize("Scheduled Restarts:"));
        for (ZonedDateTime restart : sortedRestarts) {
            String formattedString = restart.format(this.formatter);
            if (this.restartScheduler.isRestartCanceled(restart)) {
                sender.sendMessage((Component)this.mm.deserialize("<strikethrough>" + formattedString + " (Canceled)"));
                continue;
            }
            if (scheduledReached) {
                sender.sendMessage((Component)this.mm.deserialize("<gray><italic>" + formattedString + " (Scheduled)"));
                continue;
            }
            sender.sendMessage((Component)this.mm.deserialize("<b>" + formattedString + " (Scheduled)"));
            scheduledReached = true;
        }
        return true;
    }

    private boolean commandSetRestart(Audience sender, String[] args) {
        String[] restartArgs = Arrays.copyOfRange(args, 1, args.length);
        String _restartTime = this.buildRestartTime(sender, restartArgs);
        if (_restartTime == null) {
            return false;
        }
        if (this.restartScheduler.isRestartScheduled(_restartTime)) {
            sender.sendMessage((Component)this.mm.deserialize("<red>A restart is already scheduled for this time!"));
            return false;
        }
        boolean success = this.restartScheduler.scheduleRestart(_restartTime, this.plugin.getMessages(), this.plugin.getTitles(), this.plugin.getSubtitles(), this.plugin.getCommands());
        if (!success) {
            sender.sendMessage((Component)this.mm.deserialize("<red>Invalid time format!"));
            return false;
        }
        sender.sendMessage((Component)this.mm.deserialize("Auto restart is scheduled at " + _restartTime));
        sender.sendMessage((Component)this.mm.deserialize("<yellow>Note that this scheduled time is not saved and will be reset on server restart."));
        return true;
    }

    private boolean commandReload(Audience sender) {
        this.plugin.reload();
        sender.sendMessage((Component)this.mm.deserialize("Configuration reloaded successfully."));
        return true;
    }

    private ArrayList<String> tabCompleteDate(String[] args, int startIndex) {
        ArrayList<String> completions = new ArrayList<String>();
        switch (args.length - startIndex) {
            case 1: {
                int i = 0;
                while (i < 24) {
                    completions.add(String.valueOf(i));
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < 60) {
                    completions.add(String.valueOf(i));
                    ++i;
                }
                break;
            }
            case 3: {
                completions.add("Daily");
                completions.add("Monday");
                completions.add("Tuesday");
                completions.add("Wednesday");
                completions.add("Thursday");
                completions.add("Friday");
                completions.add("Saturday");
                completions.add("Sunday");
                break;
            }
        }
        return completions;
    }

    private String buildRestartTime(Audience sender, String[] args) {
        String day = "Daily";
        int hour = -1;
        int minute = -1;
        if (args.length < 2) {
            sender.sendMessage((Component)this.mm.deserialize("<red>Not enough arguments!"));
            return null;
        }
        if (args.length >= 3) {
            day = args[2];
        }
        try {
            hour = Integer.parseInt(args[0]);
            minute = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage((Component)this.mm.deserialize("<red>Hour and minute must be numbers!"));
            return null;
        }
        if (this.util.weekDayToInt(day) == -1) {
            sender.sendMessage((Component)this.mm.deserialize("<red>Invalid day! Use Daily, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday or Sunday."));
            return null;
        }
        String _restartTime = String.valueOf(day) + ";" + String.format("%02d", hour) + ":" + String.format("%02d", minute);
        return _restartTime;
    }
}

