/*
 * Decompiled with CFR 0.152.
 */
package com.teunjojo;

import com.teunjojo.SimpleAutoRestart;
import com.teunjojo.Utility;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class RestartScheduler {
    private final SimpleAutoRestart plugin;
    private final Utility util = new Utility();
    private final MiniMessage mm = MiniMessage.miniMessage();
    private Set<ZonedDateTime> scheduledRestarts = new HashSet<ZonedDateTime>();
    private Set<ZonedDateTime> canceledRestarts = new HashSet<ZonedDateTime>();
    private Timer timer = new Timer(true);

    public RestartScheduler(SimpleAutoRestart plugin) {
        this.plugin = plugin;
    }

    public boolean scheduleRestart(String _restartTime, final Map<Long, String> _messages, final Map<Long, String> _titles, final Map<Long, String> _subtitles, final List<String> _commands) {
        final ZonedDateTime nextRestart = this.parseRestartTime(_restartTime);
        ZonedDateTime now = ZonedDateTime.now();
        if (this.isRestartScheduled(nextRestart)) {
            this.plugin.getLogger().warning("A restart is already scheduled for: " + _restartTime);
            return false;
        }
        Duration duration = Duration.between(now, nextRestart);
        long initialDelayInSeconds = duration.getSeconds();
        for (final Long delay : _messages.keySet()) {
            if (delay > initialDelayInSeconds) continue;
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (RestartScheduler.this.getNextRestart() == nextRestart && !RestartScheduler.this.isRestartCanceled(nextRestart)) {
                        Audience adventureAudience = RestartScheduler.this.plugin.adventure().all();
                        String messageRaw = (String)_messages.get(delay);
                        TextComponent messageLegacy = LegacyComponentSerializer.legacyAmpersand().deserialize(messageRaw.replace('\u00a7', '&'));
                        String serializedMessage = ((String)RestartScheduler.this.mm.serialize(messageLegacy)).replace("\\", "");
                        Object messageFinal = RestartScheduler.this.mm.deserialize(serializedMessage);
                        adventureAudience.sendMessage((Component)messageFinal);
                    }
                }
            }, (initialDelayInSeconds - delay) * 1000L);
        }
        for (final Long delay : _titles.keySet()) {
            if (delay > initialDelayInSeconds) continue;
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (RestartScheduler.this.getNextRestart() == nextRestart && !RestartScheduler.this.isRestartCanceled(nextRestart)) {
                        Audience adventurePlayers = RestartScheduler.this.plugin.adventure().players();
                        String titleRaw = (String)_titles.get(delay);
                        String subtitleRaw = (String)_subtitles.get(delay);
                        TextComponent titleLegacy = LegacyComponentSerializer.legacyAmpersand().deserialize(titleRaw.replace('\u00a7', '&'));
                        TextComponent subtitleLegacy = LegacyComponentSerializer.legacyAmpersand().deserialize(subtitleRaw.replace('\u00a7', '&'));
                        String serializedTitle = ((String)RestartScheduler.this.mm.serialize(titleLegacy)).replace("\\", "");
                        String serializedSubtitle = ((String)RestartScheduler.this.mm.serialize(subtitleLegacy)).replace("\\", "");
                        Object titleFinal = RestartScheduler.this.mm.deserialize(serializedTitle);
                        Object subtitleFinal = RestartScheduler.this.mm.deserialize(serializedSubtitle);
                        Title title = Title.title(titleFinal, subtitleFinal);
                        adventurePlayers.showTitle(title);
                    }
                }
            }, (initialDelayInSeconds - delay) * 1000L);
        }
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (RestartScheduler.this.getNextRestart() == nextRestart && !RestartScheduler.this.isRestartCanceled(nextRestart)) {
                    _commands.forEach(command -> Bukkit.getScheduler().runTask((Plugin)RestartScheduler.this.plugin, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command)));
                }
                RestartScheduler.this.scheduledRestarts.remove(nextRestart);
                RestartScheduler.this.canceledRestarts.remove(nextRestart);
            }
        }, initialDelayInSeconds * 1000L);
        this.scheduledRestarts.add(nextRestart);
        this.canceledRestarts.remove(nextRestart);
        this.plugin.getLogger().info("Reboot set for: " + _restartTime);
        return true;
    }

    public boolean isRestartScheduled(ZonedDateTime dateTime) {
        return this.scheduledRestarts.contains(dateTime);
    }

    public boolean isRestartScheduled(String _restartTime) {
        ZonedDateTime restartTime = this.parseRestartTime(_restartTime);
        return this.isRestartScheduled(restartTime);
    }

    public void cancelRestart(ZonedDateTime dateTime) {
        this.scheduledRestarts.remove(dateTime);
        this.canceledRestarts.add(dateTime);
    }

    public void cancelRestart(String _restartTime) {
        ZonedDateTime restartTime = this.parseRestartTime(_restartTime);
        this.cancelRestart(restartTime);
    }

    public boolean isRestartCanceled(ZonedDateTime dateTime) {
        return this.canceledRestarts.contains(dateTime);
    }

    public boolean isRestartCanceled(String _restartTime) {
        ZonedDateTime restartTime = this.parseRestartTime(_restartTime);
        return this.isRestartCanceled(restartTime);
    }

    public void resumeRestart(ZonedDateTime dateTime) {
        this.canceledRestarts.remove(dateTime);
        this.scheduledRestarts.add(dateTime);
    }

    public void resumeRestart(String _restartTime) {
        ZonedDateTime restartTime = this.parseRestartTime(_restartTime);
        this.resumeRestart(restartTime);
    }

    public ZonedDateTime getNextRestart() {
        ZonedDateTime nextRestart = null;
        ZonedDateTime nextScheduledRestart = null;
        for (ZonedDateTime scheduledRestart : this.scheduledRestarts) {
            if (nextScheduledRestart != null && !scheduledRestart.isBefore(nextScheduledRestart)) continue;
            nextScheduledRestart = scheduledRestart;
        }
        ZonedDateTime nextCanceledRestart = null;
        for (ZonedDateTime canceledRestart : this.canceledRestarts) {
            if (nextCanceledRestart != null && !canceledRestart.isBefore(nextCanceledRestart)) continue;
            nextCanceledRestart = canceledRestart;
        }
        nextRestart = nextScheduledRestart != null && (nextCanceledRestart == null || nextScheduledRestart.isBefore(nextCanceledRestart)) ? nextScheduledRestart : nextCanceledRestart;
        return nextRestart;
    }

    public ZonedDateTime parseRestartTime(String _restartTime) {
        String[] parts = _restartTime.split(";");
        String dayPart = parts[0];
        String timePart = parts[1];
        int hour = Integer.parseInt(timePart.split(":")[0]);
        int minute = Integer.parseInt(timePart.split(":")[1]);
        ZonedDateTime now = ZonedDateTime.now();
        int currentDayOfWeek = now.getDayOfWeek().getValue();
        int targetDayOfWeek = this.util.weekDayToInt(dayPart);
        ZonedDateTime nextRestart = now.withHour(hour).withMinute(minute);
        nextRestart = nextRestart.withSecond(0).withNano(0);
        int daysUntilTarget = 0;
        if (targetDayOfWeek == 0) {
            if (nextRestart.isBefore(now)) {
                daysUntilTarget = 1;
            }
        } else {
            daysUntilTarget = (targetDayOfWeek - currentDayOfWeek + 7) % 7;
            if (daysUntilTarget == 0 && nextRestart.isBefore(now)) {
                daysUntilTarget += 7;
            }
        }
        nextRestart = nextRestart.plusDays(daysUntilTarget);
        return nextRestart;
    }

    public Set<ZonedDateTime> getScheduledRestarts() {
        return this.scheduledRestarts;
    }

    public Set<ZonedDateTime> getCanceledRestarts() {
        return this.canceledRestarts;
    }

    public void reset() {
        this.scheduledRestarts.clear();
        this.canceledRestarts.clear();
        this.timer.cancel();
        this.timer = new Timer();
    }
}

