/*
 * Decompiled with CFR 0.152.
 */
package com.teunjojo;

import com.teunjojo.CommandMain;
import com.teunjojo.RestartScheduler;
import com.teunjojo.UpdateChecker;
import com.teunjojo.bstats.bukkit.Metrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SimpleAutoRestart
extends JavaPlugin {
    SimpleAutoRestart plugin = this;
    private BukkitAudiences adventure;
    private RestartScheduler restartScheduler;
    private List<String> restartTimes = new ArrayList<String>();
    private Map<Long, String> messages = new HashMap<Long, String>();
    private Map<Long, String> titles = new HashMap<Long, String>();
    private Map<Long, String> subtitles = new HashMap<Long, String>();
    private List<String> commands = new ArrayList<String>();

    public void onEnable() {
        int pluginId = 17760;
        new Metrics(this, pluginId);
        new UpdateChecker(this).getVersion(version -> {
            version = version.replaceFirst("v", "");
            if (!this.getDescription().getVersion().equals(version)) {
                this.getLogger().warning("A new version of SimpleAutoRestart is available: v" + version + " (Current version: v" + this.getDescription().getVersion() + ")");
            }
        });
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.restartScheduler = new RestartScheduler(this);
        CommandMain commandMain = new CommandMain(this.plugin);
        this.getCommand("autorestart").setExecutor((CommandExecutor)commandMain);
        this.getCommand("simpleautorestart").setExecutor((CommandExecutor)commandMain);
        this.getCommand("sar").setExecutor((CommandExecutor)commandMain);
        if (this.loadConfig() == null) {
            this.getLogger().warning("Failed to load the configuration file.");
            return;
        }
        this.scheduleRestarts();
    }

    public void onDisable() {
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
    }

    public void scheduleRestarts() {
        for (String restartTime : this.restartTimes) {
            if (this.restartScheduler.scheduleRestart(restartTime, this.messages, this.titles, this.subtitles, this.commands)) continue;
            this.getLogger().severe("Failed to schedule the restart for: " + restartTime);
        }
    }

    public void reload() {
        this.reloadConfig();
        this.loadConfig();
        this.restartScheduler.reset();
        this.scheduleRestarts();
    }

    public FileConfiguration loadConfig() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        Object restartTimeObject = config.get("restartTime");
        if (restartTimeObject instanceof String) {
            this.restartTimes.add((String)restartTimeObject);
        } else if (restartTimeObject instanceof List) {
            this.restartTimes = (List)restartTimeObject;
        } else {
            this.getLogger().warning("Invalid format for 'restartTime' in the configuration file.");
            this.restartTimes = new ArrayList<String>();
            return null;
        }
        if (config.getString("messages.now") != null) {
            config.set("messages.0", (Object)config.getString("messages.now"));
            config.set("messages.1", (Object)config.getString("messages.1sec"));
            config.set("messages.2", (Object)config.getString("messages.2sec"));
            config.set("messages.3", (Object)config.getString("messages.3sec"));
            config.set("messages.60", (Object)config.getString("messages.1min"));
            config.set("messages.120", (Object)config.getString("messages.2min"));
            config.set("messages.180", (Object)config.getString("messages.3min"));
            config.set("messages.300", (Object)config.getString("messages.5min"));
            config.set("messages.now", null);
            config.set("messages.1sec", null);
            config.set("messages.2sec", null);
            config.set("messages.3sec", null);
            config.set("messages.1min", null);
            config.set("messages.2min", null);
            config.set("messages.3min", null);
            config.set("messages.5min", null);
            this.saveConfig();
            this.reloadConfig();
        }
        if (config.getConfigurationSection("messages") != null) {
            for (String key : config.getConfigurationSection("messages").getKeys(false)) {
                this.messages.put(Long.parseLong(key), config.getString("messages." + key));
            }
        }
        if (config.getConfigurationSection("titles") != null) {
            for (String key : config.getConfigurationSection("titles").getKeys(false)) {
                this.titles.put(Long.parseLong(key), config.getString("titles." + key));
            }
        }
        if (config.getConfigurationSection("subtitles") != null) {
            for (String key : config.getConfigurationSection("subtitles").getKeys(false)) {
                this.subtitles.put(Long.parseLong(key), config.getString("subtitles." + key));
            }
        }
        this.commands = config.getStringList("commands");
        if (this.commands.isEmpty()) {
            config.set("commands", (Object)new ArrayList<String>(){
                {
                    this.add("restart");
                }
            });
            this.saveConfig();
            this.reloadConfig();
            this.commands = config.getStringList("commands");
        }
        return config;
    }

    public BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    public RestartScheduler getRestartScheduler() {
        return this.restartScheduler;
    }

    public List<String> getRestartTimes() {
        return this.restartTimes;
    }

    public Map<Long, String> getMessages() {
        return this.messages;
    }

    public Map<Long, String> getTitles() {
        return this.titles;
    }

    public Map<Long, String> getSubtitles() {
        return this.subtitles;
    }

    public List<String> getCommands() {
        return this.commands;
    }
}

