/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public class BaseContainerBlockEntity
extends BlockEntity {
    private final List<ItemStack> items = new ArrayList<ItemStack>(9);
    private int capacity = 9;
    protected static final Logger LOGGER = LogUtils.getLogger();

    public BaseContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int value) {
        if (value > this.capacity) {
            this.capacity = value;
        }
    }

    protected void VerifyCapacity() {
        for (int i = this.items.size(); i < this.capacity; ++i) {
            this.items.add(ItemStack.EMPTY);
        }
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.VerifyCapacity();
        for (int i = 0; i < this.capacity; ++i) {
            Optional readValue = input.read("item" + i, ItemStack.CODEC);
            if (readValue.isPresent()) {
                this.items.set(i, (ItemStack)readValue.get());
                continue;
            }
            this.items.set(i, ItemStack.EMPTY);
        }
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.saveInternal(output);
    }

    protected void saveInternal(ValueOutput output) {
        this.VerifyCapacity();
        for (int i = 0; i < this.capacity; ++i) {
            if (!this.items.get(i).isEmpty()) {
                output.store("item" + i, ItemStack.CODEC, (Object)this.items.get(i));
                continue;
            }
            output.discard("item" + i);
        }
    }

    public void handleUpdateTag(ValueInput input) {
        this.loadWithComponents(input);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        try (ProblemReporter.ScopedCollector pr = new ProblemReporter.ScopedCollector(LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)pr.forChild(this.problemPath()), (HolderLookup.Provider)registries);
            this.saveInternal((ValueOutput)output);
            CompoundTag compoundTag = output.buildResult();
            return compoundTag;
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void DropAll() {
        this.VerifyCapacity();
        for (int i = 0; i < this.capacity; ++i) {
            Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)this.items.get(i));
            this.ClearItem(i);
        }
    }

    public ItemStack GetItem(int slot) {
        this.VerifyCapacity();
        return this.items.get(slot);
    }

    public void DepositItem(int slot, ItemStack itemStack) {
        this.VerifyCapacity();
        this.items.set(slot, itemStack);
        this.setChanged();
    }

    public void ClearItem(int slot) {
        this.VerifyCapacity();
        this.items.set(slot, ItemStack.EMPTY);
        this.setChanged();
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.DropAll();
    }
}

