/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableBlockEntity;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class DualTableBlockEntity
extends SimpleTableBlockEntity {
    private int data0 = 0;
    private Direction cachedDirection;
    private AABB cachedRenderingAABB = null;

    public DualTableBlockEntity(BlockPos pos, BlockState state) {
        super(Registration.DUAL_TABLE_BE.get(), pos, state);
        this.setCapacity(22);
    }

    public DualTableBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.setCapacity(22);
    }

    public void StoreIntegerData(int index, int value) {
        assert (index == 0);
        this.data0 = value;
    }

    public int GetIntegerData(int index) {
        assert (index == 0);
        return this.data0;
    }

    @Override
    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.data0 = input.getIntOr("int0", 0);
    }

    @Override
    protected void saveInternal(ValueOutput output) {
        output.putInt("int0", this.data0);
        super.saveInternal(output);
    }

    public Direction getDirection() {
        if (this.cachedDirection == null) {
            this.cachedDirection = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }
        return this.cachedDirection;
    }

    public AABB getRenderBoundingBox() {
        if (this.cachedRenderingAABB == null && !this.worldPosition.equals((Object)BlockPos.ZERO)) {
            this.cachedRenderingAABB = new AABB((double)(this.worldPosition.getX() - 1), (double)(this.worldPosition.getY() + 0), (double)(this.worldPosition.getZ() - 1), (double)(this.worldPosition.getX() + 2), (double)(this.worldPosition.getY() + 1), (double)(this.worldPosition.getZ() + 2));
        }
        return this.cachedRenderingAABB;
    }
}

