/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import moonfather.workshop_for_handsome_adventurer.CommonConfig;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class PotionShelfBlockEntity
extends ToolRackBlockEntity {
    private static final int MAX_CAPACITY = 9;
    private final List<Integer> itemCounts = new ArrayList<Integer>(9);

    public PotionShelfBlockEntity(BlockPos pos, BlockState state) {
        super(Registration.POTION_SHELF_BE.get(), pos, state, 9, 6);
    }

    public PotionShelfBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state, 9, 6);
    }

    public PotionShelfBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int capacity, int slotCount) {
        super(blockEntityType, pos, state, capacity, slotCount);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        Optional array = input.getIntArray("Counts");
        if (array.isPresent()) {
            for (int i = 0; i < ((int[])array.get()).length; ++i) {
                this.itemCounts.set(i, ((int[])array.get())[i]);
                if (((int[])array.get())[i] != 0 || this.GetItem(i).isEmpty()) continue;
                this.ClearItem(i);
            }
        }
    }

    @Override
    protected void saveInternal(ValueOutput output) {
        super.saveInternal(output);
        output.putIntArray("Counts", this.itemCounts.stream().mapToInt(Integer::valueOf).toArray());
    }

    @Override
    public int getNumberOfItemsInOneRow() {
        return 3;
    }

    @Override
    public void DropAll() {
        this.VerifyCapacity();
        for (int slot = 0; slot < this.getCapacity(); ++slot) {
            for (int j = 0; j < this.itemCounts.get(slot); ++j) {
                ItemStack potion = this.GetItem(slot);
                Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)potion.copy());
            }
            this.ClearItem(slot);
            this.itemCounts.set(slot, 0);
        }
    }

    public ItemStack TakeOutPotion(int slot) {
        this.VerifyCapacity();
        if (this.itemCounts.get(slot) == 1) {
            ItemStack result = this.GetItem(slot);
            this.ClearItem(slot);
            this.itemCounts.set(slot, 0);
            this.setChanged();
            return result;
        }
        if (this.itemCounts.get(slot) > 1) {
            ItemStack result = this.GetItem(slot).copy();
            result.setCount(1);
            this.itemCounts.set(slot, this.itemCounts.get(slot) - 1);
            this.setChanged();
            return result;
        }
        return ItemStack.EMPTY;
    }

    public void DepositPotion(int slot, ItemStack itemStack) {
        this.VerifyCapacity();
        if (this.itemCounts.get(slot) == 0) {
            ItemStack copy = itemStack.copy();
            copy.setCount(1);
            itemStack.shrink(1);
            this.DepositItem(slot, copy);
            this.itemCounts.set(slot, 1);
        } else {
            itemStack.shrink(1);
            this.itemCounts.set(slot, this.itemCounts.get(slot) + 1);
        }
        this.setChanged();
    }

    public void DepositPotionStack(int slot, ItemStack itemStack) {
        this.VerifyCapacity();
        int count = Math.min(itemStack.getCount(), this.GetRemainingRoom(slot));
        if (this.itemCounts.get(slot) == 0) {
            ItemStack copy = itemStack.copy();
            copy.setCount(1);
            itemStack.shrink(count);
            this.DepositItem(slot, copy);
            this.itemCounts.set(slot, count);
        } else {
            itemStack.shrink(count);
            this.itemCounts.set(slot, this.itemCounts.get(slot) + count);
        }
        this.setChanged();
    }

    public ItemStack TakeOutPotionStack(int slot) {
        this.VerifyCapacity();
        int count = Math.min(this.GetItem(slot).getMaxStackSize(), this.itemCounts.get(slot));
        if (this.itemCounts.get(slot) == 0) {
            return ItemStack.EMPTY;
        }
        if (this.itemCounts.get(slot) == count) {
            ItemStack result = this.GetItem(slot);
            result.setCount(count);
            this.ClearItem(slot);
            this.itemCounts.set(slot, 0);
            this.setChanged();
            return result;
        }
        ItemStack result = this.GetItem(slot).copy();
        result.setCount(count);
        this.itemCounts.set(slot, this.itemCounts.get(slot) - count);
        this.setChanged();
        return result;
    }

    public boolean IsSlotMaxed(int slot) {
        this.VerifyCapacity();
        if (this.GetItem(slot).isEmpty()) {
            return false;
        }
        return this.itemCounts.get(slot) >= Math.min(this.getSlotRoomMaximum(), this.GetItem(slot).getMaxStackSize() * this.getSlotRoomMultiplier());
    }

    public Integer GetRemainingRoom(int slot) {
        this.VerifyCapacity();
        if (this.itemCounts.get(slot) == 0) {
            return this.getSlotRoomMaximum();
        }
        return Math.min(this.getSlotRoomMaximum(), this.GetItem(slot).getMaxStackSize() * this.getSlotRoomMultiplier()) - this.itemCounts.get(slot);
    }

    public Integer GetRemainingItems(int slot) {
        this.VerifyCapacity();
        return this.itemCounts.get(slot);
    }

    public boolean hasSlotWithSameItemWithRemainingRoom(int slotToPlaceNew, ItemStack itemStack) {
        for (int i = 0; i < this.getCapacity(); ++i) {
            if (i == slotToPlaceNew || this.itemCounts.get(i) <= 0 || this.GetRemainingRoom(i) <= 0 || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)this.GetItem(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void VerifyCapacity() {
        super.VerifyCapacity();
        for (int i = this.itemCounts.size(); i < this.getCapacity(); ++i) {
            this.itemCounts.add(0);
        }
    }

    protected int getSlotRoomMultiplier() {
        return (Integer)CommonConfig.SlotRoomMultiplier.get();
    }

    protected int getSlotRoomMaximum() {
        return (Integer)CommonConfig.SlotRoomMaximum.get();
    }
}

