/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.renderers.ToolRackTESR;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class DiscShelfTESR
extends ToolRackTESR {
    public DiscShelfTESR(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void render(ToolRackBlockEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 camera) {
        Direction direction = ((Direction)tile.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite();
        Direction itemDirection = direction.getCounterClockWise();
        int itemsPerRow = tile.getNumberOfItemsInOneRow();
        int rows = tile.getNumberOfItems() / tile.getNumberOfItemsInOneRow();
        matrixStack.pushPose();
        matrixStack.translate(0.5 - (double)direction.getStepX() * 0.42, 0.7, 0.5 - (double)direction.getStepZ() * 0.42);
        matrixStack.scale(0.29f, 0.34f, 0.29f);
        double vertical = 0.125;
        for (int row = 0; row < rows; ++row) {
            if (row >= 1) {
                vertical += 0.75;
            }
            for (int i = 0; i < itemsPerRow; ++i) {
                ItemStack itemStack = tile.GetItem(row * itemsPerRow + i);
                if (itemStack.isEmpty()) continue;
                matrixStack.pushPose();
                double antiZFighting = (double)row * 0.003 + (double)i * 0.001;
                matrixStack.translate((double)itemDirection.getStepX() * ((double)i - 1.0) + antiZFighting, 0.0 - vertical, (double)itemDirection.getStepZ() * ((double)i - 1.0) + antiZFighting);
                matrixStack.mulPose((Quaternionfc)direction.getRotation());
                matrixStack.scale(1.0f, 1.4f, 1.0f);
                double rowExtrude = 0.225 * (double)row - 0.1;
                if (row == 2) {
                    rowExtrude += 0.025;
                }
                matrixStack.translate(0.0, rowExtrude, 0.0);
                this.renderItemStack(tile, itemStack, matrixStack, buffer, combinedLight, combinedOverlay);
                matrixStack.popPose();
            }
        }
        matrixStack.popPose();
    }

    private void renderItemStack(ToolRackBlockEntity tile, ItemStack itemStack, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (itemStack == null || itemStack.isEmpty()) {
            return;
        }
        int renderId = (int)tile.getBlockPos().asLong();
        matrixStack.mulPose((Quaternionfc)XMinus90);
        matrixStack.mulPose((Quaternionfc)YPlus180);
        if (itemStack.is(TAG_LARGER_ON_TOOLRACK_150)) {
            matrixStack.scale(1.5f, 1.1f, 1.5f);
        } else if (itemStack.is(TAG_LARGER_ON_TOOLRACK_125)) {
            matrixStack.scale(1.25f, 1.1f, 1.25f);
        }
        matrixStack.translate(0.0, 0.1, 0.0);
        Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, matrixStack, buffer, tile.getLevel(), renderId);
    }
}

