/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import moonfather.workshop_for_handsome_adventurer.ClientConfig;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.renderers.ToolRackTESR;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class SimpleTableTESR
implements BlockEntityRenderer<SimpleTableBlockEntity> {
    private static final Quaternionf XPlus90 = new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, 90.0f);
    private static final Quaternionf ZPlus180 = new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 180.0f);
    private static final Map<Integer, Quaternionf> YRotCache = new HashMap<Integer, Quaternionf>();
    private boolean shouldRender = true;

    public SimpleTableTESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(SimpleTableBlockEntity table, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, Vec3 camera) {
        Direction direction = null;
        double playerDX = (double)table.getBlockPos().getX() + 0.5 - Minecraft.getInstance().player.position().x;
        double playerDZ = (double)table.getBlockPos().getZ() + 0.5 - Minecraft.getInstance().player.position().z;
        if (Math.abs(playerDZ) > 1.0E-4 && Math.abs(Math.abs(playerDX / playerDZ) - 1.0) < 0.2 || table.getBlockPos().getX() == Minecraft.getInstance().player.blockPosition().getX() && table.getBlockPos().getZ() == Minecraft.getInstance().player.blockPosition().getZ()) {
            direction = Direction.fromYRot((double)(Minecraft.getInstance().player.yHeadRot + 180.0f));
        } else {
            direction = Direction.getNearest((int)(-1 * (int)playerDX), (int)0, (int)(-1 * (int)playerDZ), null);
            if (direction == null) {
                direction = Direction.fromYRot((double)(Minecraft.getInstance().player.yHeadRot + 180.0f));
            }
        }
        SimpleTableTESR.render3x3(poseStack, direction, bufferSource, combinedLight, combinedOverlay, table, 0, false, false);
    }

    public static void render3x3(PoseStack poseStack, Direction direction, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, SimpleTableBlockEntity table, int tableInventoryOffset, boolean unused, boolean secondary) {
        for (int j = 0; j < 9; ++j) {
            ItemStack itemstack = ToolRackTESR.removeEnchantmentsStatic(table.GetItem(tableInventoryOffset + j));
            if (itemstack == ItemStack.EMPTY) continue;
            poseStack.pushPose();
            poseStack.translate(0.0f, 1.01f, 0.0f);
            int tableOffsetX = secondary ? direction.getStepX() : 0;
            int tableOffsetZ = secondary ? direction.getStepZ() : 0;
            poseStack.translate(0.5 + (double)tableOffsetZ, 0.0, 0.5 - (double)tableOffsetX);
            poseStack.mulPose((Quaternionfc)SimpleTableTESR.getYRotation(direction, direction.getStepZ() == 0));
            double positionScale = 0.63f;
            poseStack.translate((double)(j % 3) * 0.3 * positionScale, 0.0, (double)(j / 3) * 0.3 * positionScale);
            poseStack.translate(-0.19, 0.0, -0.19);
            poseStack.mulPose((Quaternionfc)XPlus90);
            poseStack.mulPose((Quaternionfc)ZPlus180);
            float itemScale = 0.15f;
            poseStack.scale(itemScale, itemScale, itemScale / 3.0f);
            Minecraft.getInstance().getItemRenderer().renderStatic(itemstack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, bufferSource, null, j);
            poseStack.popPose();
        }
    }

    private static Quaternionf getYRotation(Direction directionToPlayer, boolean invert) {
        int one = invert ? -1 : 1;
        int y = (int)directionToPlayer.toYRot() * one;
        Quaternionf result = YRotCache.getOrDefault(y, null);
        if (result == null) {
            result = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, (float)y);
            YRotCache.put(y, result);
        }
        return result;
    }

    public boolean shouldRender(SimpleTableBlockEntity blockEntity, Vec3 location) {
        if (blockEntity.hasLevel() && blockEntity.getLevel().getLevelData().getGameTime() % 40L == 7L) {
            this.shouldRender = ClientConfig.renderItemsOnTable;
        }
        return this.shouldRender;
    }
}

