/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@ParametersAreNonnullByDefault
public class ToolRackTESR
implements BlockEntityRenderer<ToolRackBlockEntity> {
    private ItemRenderer itemRenderer = null;
    private final BlockEntityRendererProvider.Context context;
    protected static final TagKey<Item> TAG_DONT_ROTATE_ON_TOOLRACK = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"dont_rotate_on_toolrack"));
    protected static final TagKey<Item> TAG_ROTATE_180_ON_TOOLRACK = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"rotate_180_on_toolrack"));
    protected static final TagKey<Item> TAG_LARGER_ON_TOOLRACK_150 = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"larger_on_toolrack_150_percent"));
    protected static final TagKey<Item> TAG_LARGER_ON_TOOLRACK_125 = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"larger_on_toolrack_125_percent"));
    protected static final Quaternionf ZMinus45 = new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, -45.0f);
    protected static final Quaternionf ZPlus225 = new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 225.0f);
    protected static final Quaternionf ZPlus135 = new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 135.0f);
    protected static final Quaternionf ZPlus180 = new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 180.0f);
    protected static final Quaternionf XMinus90 = new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, -90.0f);
    protected static final Quaternionf YPlus180 = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 180.0f);
    private final HashMap<Integer, ItemStack> cacheForRemovingEnchantments = new HashMap();

    public ToolRackTESR(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.itemRenderer = Minecraft.getInstance().getItemRenderer();
    }

    public void render(ToolRackBlockEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 camera) {
        Direction direction = ((Direction)tile.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite();
        Direction itemDirection = direction.getCounterClockWise();
        int itemsPerRow = tile.getNumberOfItemsInOneRow();
        if (itemsPerRow == 3) {
            matrixStack.pushPose();
            matrixStack.translate(0.5 - (double)direction.getStepX() * 0.42, 0.7, 0.5 - (double)direction.getStepZ() * 0.42);
            matrixStack.scale(0.3f, 0.4f, 0.3f);
            int rowHeight = 15;
            for (int row = 0; row < 3; ++row) {
                for (int i = 0; i < itemsPerRow && tile.getNumberOfItems() > row * itemsPerRow; ++i) {
                    ItemStack itemStack = this.removeEnchantments(tile.GetItem(row * itemsPerRow + i));
                    if (itemStack.isEmpty()) continue;
                    matrixStack.pushPose();
                    double antiZFighting = (double)row * 0.003 + (double)i * 0.001;
                    matrixStack.translate((double)itemDirection.getStepX() * ((double)i - 1.0) + antiZFighting, (double)(0.0f - (float)row * ((float)rowHeight / 16.0f + 0.1875f) - 0.125f), (double)itemDirection.getStepZ() * ((double)i - 1.0) + antiZFighting);
                    matrixStack.mulPose((Quaternionfc)direction.getRotation());
                    this.renderItemStack(tile, itemStack, matrixStack, buffer, combinedLight, combinedOverlay);
                    matrixStack.popPose();
                }
            }
            matrixStack.popPose();
        } else {
            matrixStack.pushPose();
            matrixStack.translate(0.5 - (double)direction.getStepX() * 0.42, 0.7, 0.5 - (double)direction.getStepZ() * 0.42);
            matrixStack.scale(0.5f, 0.5f, 0.5f);
            int rowHeight = tile.getNumberOfItems() % 4 == 0 ? 15 : 20;
            for (int row = 0; row < 3; ++row) {
                for (int i = 0; i < itemsPerRow && tile.getNumberOfItems() > row * itemsPerRow; ++i) {
                    ItemStack itemStack = this.removeEnchantments(tile.GetItem(row * itemsPerRow + i));
                    if (itemStack.isEmpty()) continue;
                    matrixStack.pushPose();
                    double antiZFighting = (double)row * 0.003 + (double)i * 0.001;
                    matrixStack.translate((double)itemDirection.getStepX() * ((double)i - 0.5) + antiZFighting, (double)(0.0f - (float)row * ((float)rowHeight / 16.0f)), (double)itemDirection.getStepZ() * ((double)i - 0.5) + antiZFighting);
                    matrixStack.mulPose((Quaternionfc)direction.getRotation());
                    this.renderItemStack(tile, itemStack, matrixStack, buffer, combinedLight, combinedOverlay);
                    matrixStack.popPose();
                }
            }
            matrixStack.popPose();
        }
    }

    private void renderItemStack(ToolRackBlockEntity tile, ItemStack itemStack, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (itemStack != null && !itemStack.isEmpty()) {
            int renderId = (int)tile.getBlockPos().asLong();
            if (this.itemRenderer == null) {
                this.itemRenderer = Minecraft.getInstance().getItemRenderer();
            }
            matrixStack.mulPose((Quaternionfc)XMinus90);
            matrixStack.mulPose((Quaternionfc)YPlus180);
            if (itemStack.is(TAG_LARGER_ON_TOOLRACK_150)) {
                matrixStack.scale(1.5f, 1.1f, 1.5f);
            } else if (itemStack.is(TAG_LARGER_ON_TOOLRACK_125)) {
                matrixStack.scale(1.25f, 1.1f, 1.25f);
            }
            if (itemStack.is(TAG_ROTATE_180_ON_TOOLRACK)) {
                matrixStack.mulPose((Quaternionfc)ZPlus180);
            }
            if (itemStack.is(TAG_DONT_ROTATE_ON_TOOLRACK)) {
                matrixStack.translate(0.0, 0.1, 0.0);
            } else if (itemStack.has(DataComponents.BLOCKS_ATTACKS)) {
                matrixStack.translate(-0.0, -0.1, 0.14);
                matrixStack.scale(1.75f, 1.6f, 1.75f);
            } else if (itemStack.getItem().canPerformAction(itemStack, ItemAbilities.SWORD_SWEEP) || itemStack.is(ItemTags.SWORDS)) {
                matrixStack.translate(0.0, -0.2, 0.0);
                matrixStack.mulPose((Quaternionfc)ZPlus135);
            } else if (itemStack.getItem().getClass().getSimpleName().contains("rossbow") || itemStack.getItem() instanceof CrossbowItem) {
                matrixStack.translate(0.0, -0.2, 0.0);
                matrixStack.mulPose((Quaternionfc)ZPlus225);
            } else if (itemStack.get(DataComponents.POTION_CONTENTS) != null || itemStack.is(Items.GLASS_BOTTLE)) {
                matrixStack.translate(0.0, 0.1, 0.0);
            } else {
                matrixStack.mulPose((Quaternionfc)ZMinus45);
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, matrixStack, buffer, tile.getLevel(), renderId);
        }
    }

    public static ItemStack removeEnchantmentsStatic(ItemStack stored) {
        if (!stored.has(DataComponents.ENCHANTMENTS)) {
            return stored;
        }
        ItemStack result = stored.copy();
        result.remove(DataComponents.ENCHANTMENTS);
        return result;
    }

    private ItemStack removeEnchantments(ItemStack stored) {
        if (!stored.has(DataComponents.ENCHANTMENTS)) {
            return stored;
        }
        if (this.cacheForRemovingEnchantments.containsKey(stored.hashCode())) {
            return this.cacheForRemovingEnchantments.get(stored.hashCode());
        }
        ItemStack result = stored.copy();
        result.remove(DataComponents.ENCHANTMENTS);
        this.cacheForRemovingEnchantments.put(stored.hashCode(), result);
        return result;
    }

    public AABB getRenderBoundingBox(ToolRackBlockEntity blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }
}

