/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.screen_components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class SimpleButton
extends Button {
    private final ResourceLocation resourceLocationNormal;
    private final ResourceLocation resourceLocationHovered;
    private final ResourceLocation resourceLocationDisabled;
    private final int textureWidth;
    private final int textureHeight;
    private String tooltipKey = null;
    private Component tooltipInset = null;
    List<ClientTooltipComponent> tooltipLines = null;

    public SimpleButton(int x, int y, int width, int height, String texture, String suffixNormal, String suffixHovered, String suffixDisabled, int textureWidth, int textureHeight, Button.OnPress onPress, Component message) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.resourceLocationNormal = ResourceLocation.parse((String)texture.formatted(suffixNormal));
        this.resourceLocationHovered = ResourceLocation.parse((String)texture.formatted(suffixHovered));
        this.resourceLocationDisabled = ResourceLocation.parse((String)texture.formatted(suffixDisabled));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float p_94285_) {
        ResourceLocation image = this.resourceLocationNormal;
        if (this.isActive() && this.isHoveredOrFocused()) {
            image = this.resourceLocationHovered;
        } else if (!this.isActive()) {
            image = this.resourceLocationDisabled;
        }
        graphics.blit(RenderPipelines.GUI_TEXTURED, image, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.textureWidth, this.textureHeight);
    }

    public void renderTooltipsSeparately(GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        if (this.isHovered) {
            if (this.tooltipLines == null) {
                this.tooltipLines = new ArrayList<ClientTooltipComponent>(2);
                Arrays.stream(Language.getInstance().getOrDefault(this.tooltipKey).split("\n")).forEach(text -> {
                    int pos = text.indexOf("%s");
                    MutableComponent line = pos == -1 ? Component.literal((String)text).withStyle(ChatFormatting.GRAY) : Component.literal((String)text.substring(0, pos)).withStyle(ChatFormatting.GRAY).append((Component)this.tooltipInset.copy().withStyle(Style.EMPTY.withColor(0xEEAA77))).append((Component)Component.literal((String)text.substring(pos + 2)).withStyle(ChatFormatting.GRAY));
                    this.tooltipLines.add(ClientTooltipComponent.create((FormattedCharSequence)line.getVisualOrderText()));
                });
            }
            graphics.renderTooltip(font, this.tooltipLines, mouseX, mouseY - 8, DefaultTooltipPositioner.INSTANCE, null);
        }
    }

    public void setTooltipKey(String newKey) {
        this.tooltipKey = newKey;
        this.tooltipLines = null;
    }

    public void setTooltipInset(Component newTooltip) {
        this.tooltipInset = newTooltip;
        this.tooltipLines = null;
    }
}

