/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.screens;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import moonfather.workshop_for_handsome_adventurer.CommonConfig;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.PacketSender;
import moonfather.workshop_for_handsome_adventurer.block_entities.screen_components.SimpleButton;
import moonfather.workshop_for_handsome_adventurer.block_entities.screen_components.SlightlyNicerEditBox;
import moonfather.workshop_for_handsome_adventurer.block_entities.screens.SimpleTableCraftingScreen;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.integration.PolymorphAccessorClient;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;

@ParametersAreNonnullByDefault
public class InventoryAccessComponent
implements Renderable,
GuiEventListener,
NarratableEntry {
    public static final int PANEL_WIDTH = 176;
    public static final int PANEL_HEIGHT_WITHOUT_TABS = 134;
    public static final int PANEL_HEIGHT_WITH_TABS = 166;
    protected static final ResourceLocation BG_CHEST_LOCATION_3_ROWS = ResourceLocation.parse((String)"workshop_for_handsome_adventurer:textures/gui/left_panel_normal_chest.png");
    protected static final ResourceLocation BG_CHEST_LOCATION_6_ROWS = ResourceLocation.parse((String)"workshop_for_handsome_adventurer:textures/gui/left_panel_double_chest.png");
    private static final String RENAME_BUTTON_LOCATION = "workshop_for_handsome_adventurer:textures/gui/rename_%s.png";
    private static final String renameTooltipKey = "message.workshop_for_handsome_adventurer.rename";
    private static final String renameTooltip0Key = "message.workshop_for_handsome_adventurer.rename0";
    private int xOffset;
    private final List<TabButton> tabButtons = Lists.newArrayList();
    private TabButton selectedTab;
    private EditBox renameBox;
    private SimpleButton renameButton;
    private boolean visible;
    private int tickCount = 0;
    private boolean widthTooNarrow2 = false;
    private SimpleTableCraftingScreen parent;
    private boolean tabsInitialized = false;
    private boolean slotRowsFourToSixVisible = false;
    private boolean slotsMoved = false;
    private boolean suppressRenameButton = false;

    public void init(SimpleTableCraftingScreen parent, boolean widthTooNarrow) {
        this.parent = parent;
        this.updateWidth(widthTooNarrow);
        this.parent.getMinecraft().player.containerMenu = this.parent.getMenu();
        this.visible = this.isVisibleAccordingToMenuData();
        if (this.visible) {
            this.initVisuals();
            this.hideIfScreenTooNarrow();
        }
        ((SimpleTableMenu)this.parent.getMenu()).registerClientHandlerForDataSlot(0, this::onTabListChangedOnServer);
        ((SimpleTableMenu)this.parent.getMenu()).registerClientHandlerForDataSlot(2, this::onContainerSizeChangedOnServer);
    }

    private void hideIfScreenTooNarrow() {
        ((SimpleTableMenu)this.parent.getMenu()).setClientFlagScreenTooNarrow(this.widthTooNarrow2);
        ((SimpleTableMenu)this.parent.getMenu()).updateAccessSlotsOnClient();
    }

    public void initVisuals() {
        this.xOffset = (this.parent.width - this.parent.getImageWidth() - 176) / 2;
        int bottomY = (this.parent.height - this.parent.getYSize()) / 2 + 166;
        if (this.renameBox == null) {
            this.renameBox = new SlightlyNicerEditBox(this.parent.getMinecraft().font, this.xOffset, bottomY - 18, 120, 14, (Component)Component.literal((String)"Input box for new name for container"));
            this.renameBox.setMaxLength(50);
            this.renameBox.setBordered(false);
            this.renameBox.setVisible(true);
            this.renameBox.setTextColor(-3355444);
            this.renameBox.setTextShadow(false);
            this.renameButton = new SimpleButton(this.xOffset, bottomY - 23, 25, 18, RENAME_BUTTON_LOCATION, "normal", "hovered", "disabled", 32, 32, p_93751_ -> this.renameButtonClicked(), (Component)Component.literal((String)"Rename container"));
            this.renameButton.setTooltipKey((Boolean)CommonConfig.RenameChestsForFree.get() != false ? renameTooltip0Key : renameTooltipKey);
            this.renameButton.setTooltipInset((Component)Component.literal((String)""));
            this.renameButton.active = false;
        }
        this.renameBox.setX(this.xOffset + 9);
        this.renameBox.setY(bottomY - 18);
        this.renameButton.setX(this.xOffset + 7 + this.renameBox.getWidth() + 7);
        this.renameButton.setY(bottomY - 23);
        if (!this.tabsInitialized) {
            ItemStack stack;
            this.tabButtons.clear();
            this.selectedTab = null;
            for (int i = 50; i < 81 && !(stack = ((Slot)((SimpleTableMenu)this.parent.getMenu()).slots.get(i)).getItem()).isEmpty(); i += 2) {
                TabButton button = new TabButton();
                button.setMessage(stack.getHoverName());
                button.itemMain = stack;
                button.itemSub = ((Slot)((SimpleTableMenu)this.parent.getMenu()).slots.get(i + 1)).getItem();
                button.chestIndex = (i - 50) / 2;
                button.parent = this;
                this.tabButtons.add(button);
                if (button.chestIndex != ((SimpleTableMenu)this.parent.getMenu()).selectedTab) continue;
                this.tabChanged(button, true);
            }
        }
        this.tabsInitialized = true;
        if (this.selectedTab == null && this.tabButtons.size() > 0) {
            this.tabChanged(this.tabButtons.get(0), true);
            ((SimpleTableMenu)this.parent.getMenu()).updateAccessSlotsOnClient();
        }
        this.updateTabLocations();
    }

    private Boolean tabChanged(TabButton button, boolean dontSendToServer) {
        if (!((Object)((Object)button)).equals((Object)this.selectedTab)) {
            boolean canRenameContainer;
            if (this.selectedTab != null) {
                this.selectedTab.setStateTriggered(false);
            }
            button.setStateTriggered(true);
            this.selectedTab = button;
            ((SimpleTableMenu)this.parent.getMenu()).selectedTab = button.chestIndex;
            if (!dontSendToServer) {
                PacketSender.sendTabChangeToServer(button.chestIndex);
            }
            this.renameButton.setTooltipInset(button.itemMain.getHoverName());
            this.renameBox.setValue("");
            Integer flagsBoxed = (Integer)button.itemMain.get((DataComponentType)Registration.TAB_FLAGS.get());
            int flags = flagsBoxed != null ? flagsBoxed : 1;
            this.renameBox.visible = canRenameContainer = (flags & 4) == 0;
            this.renameButton.visible = canRenameContainer;
            this.slotRowsFourToSixVisible = (flags & 2) == 2;
            return true;
        }
        return false;
    }

    private Boolean tabChanged(TabButton button) {
        return this.tabChanged(button, false);
    }

    private void onTabListChangedOnServer(Integer flag) {
        ItemStack stack;
        if (flag % 2 == 0) {
            return;
        }
        int previousTabCount = this.tabButtons.size();
        int newTabCount = 0;
        for (int i = 50; i < 81 && !(stack = ((Slot)((SimpleTableMenu)this.parent.getMenu()).slots.get(i)).getItem()).isEmpty(); i += 2) {
            ++newTabCount;
        }
        if (previousTabCount != newTabCount) {
            ((SimpleTableMenu)this.parent.getMenu()).selectedTab = -1;
        }
        this.tabsInitialized = false;
        this.initVisuals();
        if (previousTabCount != 0 || newTabCount > 0) {
            // empty if block
        }
    }

    private void onContainerSizeChangedOnServer(Integer value) {
    }

    public boolean areSlotRowsFourToSixVisible() {
        return this.slotRowsFourToSixVisible;
    }

    public int getWidth() {
        if (!(!this.isVisibleAccordingToMenuData() || this.widthTooNarrow2 || this.tabsInitialized && this.tabButtons.size() <= 0)) {
            return 176;
        }
        return 0;
    }

    public void render(GuiGraphics graphics, int p_100320_, int p_100321_, float p_100322_) {
        if (this.isVisibleTotal()) {
            int x = this.parent.getGuiLeft();
            int y = (this.parent.height - this.parent.getYSize()) / 2;
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.getBackground(), x, y, 0.0f, 0.0f, 176, 166, 256, 256);
            this.renameBox.render(graphics, p_100320_, p_100321_, p_100322_);
            this.renameButton.render(graphics, p_100320_, p_100321_, p_100322_);
            for (StateSwitchingButton stateSwitchingButton : this.tabButtons) {
                stateSwitchingButton.render(graphics, p_100320_, p_100321_, p_100322_);
            }
        }
    }

    private ResourceLocation getBackground() {
        if (this.selectedTab != null && this.slotRowsFourToSixVisible) {
            return BG_CHEST_LOCATION_6_ROWS;
        }
        return BG_CHEST_LOCATION_3_ROWS;
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.isVisibleTotal()) {
            this.renameButton.renderTooltipsSeparately(graphics, this.parent.getFont(), mouseX, mouseY);
            for (TabButton tabButton : this.tabButtons) {
                if (!tabButton.isHoveredOrFocused()) continue;
                if (this.parent.getMinecraft().screen == null) break;
                graphics.renderTooltip(this.parent.getFont(), tabButton.getMessageForTooltip(), mouseX + 2, mouseY + 12, DefaultTooltipPositioner.INSTANCE, null);
                break;
            }
        }
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.visible ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput output) {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.tabButtons);
        Screen.NarratableSearchResult screen$narratablesearchresult = Screen.findNarratableWidget((List)list, (NarratableEntry)null);
        if (screen$narratablesearchresult != null) {
            screen$narratablesearchresult.entry.updateNarration(output.nest());
        }
    }

    public boolean isMouseOver(double p_100353_, double p_100354_) {
        return false;
    }

    public void setFocused(boolean p_265728_) {
    }

    public boolean isFocused() {
        return this.renameBox.isFocused();
    }

    public void removed() {
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    public boolean isVisible() {
        return this.visible && this.tabButtons.size() > 0;
    }

    public boolean isVisibleTotal() {
        return this.isVisible() && (!this.tabsInitialized || this.tabButtons.size() > 0) && !this.widthTooNarrow2;
    }

    private boolean isVisibleAccordingToMenuData() {
        return ((SimpleTableMenu)this.parent.getMenu()).showInventoryAccess();
    }

    protected void setVisible(boolean value) {
        boolean changeTab;
        boolean bl = changeTab = value && !this.visible;
        if (value) {
            this.initVisuals();
        }
        this.visible = value;
        this.updateSlotPositions();
        if (changeTab) {
            this.tabChanged(this.tabButtons.get(0), true);
        }
        this.hideIfScreenTooNarrow();
        this.updatePolymorphButton();
    }

    public void tick() {
        boolean flag;
        ++this.tickCount;
        if ((this.tickCount < 5 || this.tickCount % 10 == 6) && this.visible != (flag = this.isVisibleAccordingToMenuData())) {
            this.setVisible(flag);
            this.parent.setPositionsX();
        }
        if (this.isVisibleTotal() && this.renameBox != null && this.tickCount % 10 == 5) {
            this.suppressRenameButton = false;
            boolean hasEnoughXP = this.parent.getMinecraft().player.isCreative() || (Boolean)CommonConfig.RenameChestsForFree.get() != false || this.parent.getMinecraft().player.experienceLevel > 0;
            this.renameButton.active = !this.renameBox.getValue().isEmpty() && hasEnoughXP;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.renameBox.isFocused()) {
            if (scanCode == 23) {
                this.renameBox.setFocused(false);
                return true;
            }
            this.renameBox.keyPressed(keyCode, scanCode, modifiers);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char p_94732_, int p_94733_) {
        if (this.renameBox.isFocused() && this.renameBox.charTyped(p_94732_, p_94733_)) {
            return true;
        }
        return super.charTyped(p_94732_, p_94733_);
    }

    private void updateWidth(boolean widthTooNarrow) {
        if (this.widthTooNarrow2 != widthTooNarrow) {
            this.widthTooNarrow2 = widthTooNarrow;
            this.updateSlotPositions();
        }
    }

    private void updateSlotPositions() {
        block5: {
            block4: {
                if (!this.isVisibleTotal() || this.slotsMoved) break block4;
                for (int k = 0; k < ((SimpleTableMenu)this.parent.getMenu()).slots.size(); ++k) {
                    ((Slot)((SimpleTableMenu)this.parent.getMenu()).slots.get((int)k)).x += 178;
                }
                this.slotsMoved = true;
                for (GuiEventListener c : this.parent.children()) {
                    if (!(c instanceof Button)) continue;
                    Button b = (Button)c;
                    b.setX(b.getX() + 178);
                }
                break block5;
            }
            if (this.isVisibleTotal() || !this.slotsMoved) break block5;
            for (int k = 0; k < ((SimpleTableMenu)this.parent.getMenu()).slots.size(); ++k) {
                ((Slot)((SimpleTableMenu)this.parent.getMenu()).slots.get((int)k)).x -= 178;
            }
            this.slotsMoved = false;
            for (GuiEventListener c : this.parent.children()) {
                if (!(c instanceof Button)) continue;
                Button b = (Button)c;
                b.setX(b.getX() - 178);
            }
        }
    }

    private void updateTabLocations() {
        int startx = this.xOffset + 3;
        int starty = (this.parent.height - this.parent.getYSize()) / 2;
        int counter = 0;
        boolean topRow = true;
        for (StateSwitchingButton stateSwitchingButton : this.tabButtons) {
            if (counter >= 8) {
                topRow = false;
                counter -= 8;
                starty += 163;
            }
            stateSwitchingButton.setPosition(startx + 21 * counter, starty);
            ++counter;
            stateSwitchingButton.visible = true;
        }
    }

    private void updatePolymorphButton() {
        if (ModList.get().isLoaded("polymorph")) {
            PolymorphAccessorClient.updatePosition();
        }
    }

    public void slotClicked(@Nullable Slot slot) {
    }

    public boolean hasClickedOutside(double mouseX, double mouseY, int leftPos, int topPos, int width, int height, int mouseButton) {
        if (!this.isVisibleTotal()) {
            return true;
        }
        return mouseX < (double)leftPos || mouseX > (double)(leftPos + 176) || mouseY < (double)topPos || mouseY > (double)(topPos + height);
    }

    public boolean mouseClicked(double v1, double v2, int mouseButton) {
        if (this.renameBox != null) {
            if (this.renameBox.isMouseOver(v1, v2)) {
                this.renameBox.setFocused(true);
                return true;
            }
            this.renameBox.setFocused(false);
        }
        for (TabButton tabButton : this.tabButtons) {
            if (!tabButton.isMouseOver(v1, v2)) continue;
            this.tabChanged(tabButton);
            return true;
        }
        if (this.renameButton != null && this.renameButton.active && !this.suppressRenameButton && this.renameButton.isMouseOver(v1, v2)) {
            this.suppressRenameButton = true;
            this.renameButton.mouseClicked(v1, v2, mouseButton);
            return true;
        }
        return false;
    }

    private void renameButtonClicked() {
        PacketSender.sendRenameRequestToServer(this.renameBox.getValue());
        this.selectedTab.setMessage((Component)Component.literal((String)this.renameBox.getValue()));
        this.renameBox.setValue("");
    }

    private static class TabButton
    extends StateSwitchingButton {
        private static final int TAB_ROW_COUNT = 8;
        public static final int WIDTH = 22;
        public static final int HEIGHT = 26;
        public InventoryAccessComponent parent;
        private ItemStack itemMain = ItemStack.EMPTY;
        private ItemStack itemSub = ItemStack.EMPTY;
        private int chestIndex;
        private static final ResourceLocation IMAGE_ACTIVE_TAB = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/tab_top_active.png");
        private static final ResourceLocation IMAGE_INACTIVE_TAB = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/tab_top_inactive.png");
        private static final ResourceLocation IMAGE_ACTIVE_BOTTOM_TAB = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/tab_bottom_active.png");
        private static final ResourceLocation IMAGE_INACTIVE_BOTTOM_TAB = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/tab_bottom_inactive.png");
        private ResourceLocation imageActiveTab;
        private ResourceLocation imageInactiveTab;
        boolean checkedForSpecialScaling = false;
        boolean doSpecialScaling = false;
        private Function<TabButton, Boolean> handler = null;
        private List<ClientTooltipComponent> tooltip = null;

        public TabButton() {
            super(0, 0, 22, 26, false);
        }

        public void renderWidget(GuiGraphics graphics, int p_100458_, int p_100459_, float p_100460_) {
            int texY;
            int texX = 2;
            int n = texY = this.chestIndex < 8 ? 2 : 4;
            if (this.imageActiveTab == null) {
                this.imageActiveTab = this.chestIndex < 8 ? IMAGE_ACTIVE_TAB : IMAGE_ACTIVE_BOTTOM_TAB;
                this.imageInactiveTab = this.chestIndex < 8 ? IMAGE_INACTIVE_TAB : IMAGE_INACTIVE_BOTTOM_TAB;
            }
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.isStateTriggered ? this.imageActiveTab : this.imageInactiveTab, this.getX(), this.getY(), (float)texX, (float)texY, this.width, this.height, 32, 32);
            this.renderIcon(graphics);
        }

        private void renderIcon(GuiGraphics graphics) {
            int x = (this.parent.parent.width - this.parent.parent.getXSize()) / 2;
            int y = (this.parent.parent.height - this.parent.parent.getYSize()) / 2;
            int tabIndexInRow = this.chestIndex;
            int textureYAdjustment = 0;
            int textureYAdjustment2 = 0;
            if (this.chestIndex >= 8) {
                tabIndexInRow = this.chestIndex - 8;
                textureYAdjustment = 3;
                y = y + this.parent.parent.getYSize() - 26 - 39 - textureYAdjustment;
                textureYAdjustment2 = 1;
            }
            if (!this.checkedForSpecialScaling) {
                this.doSpecialScaling = !(this.itemMain.getItem() instanceof BlockItem);
                this.checkedForSpecialScaling = true;
            }
            if (!this.doSpecialScaling) {
                graphics.renderFakeItem(this.itemMain, this.getX() + 1, this.getY() + 3 + textureYAdjustment2);
            } else {
                graphics.pose().pushMatrix();
                graphics.pose().scale(0.6666667f, 0.6666667f);
                graphics.renderFakeItem(this.itemMain, (int)((double)(x + tabIndexInRow * 21 + 7) * 1.5), (int)((double)(y + 5) * 1.5));
                graphics.pose().popMatrix();
            }
            graphics.pose().pushMatrix();
            graphics.pose().scale(0.6666667f, 0.6666667f);
            graphics.renderFakeItem(this.itemSub, (int)((double)(x + tabIndexInRow * 21 + 13) * 1.5), (int)((double)(this.getY() + textureYAdjustment2 + 12) * 1.5));
            graphics.pose().popMatrix();
        }

        public void setClickHandler(Function<TabButton, Boolean> handler) {
            this.handler = handler;
        }

        public boolean mouseClicked(double p_93641_, double p_93642_, int p_93643_) {
            if (this.handler != null) {
                return this.handler.apply(this);
            }
            return super.mouseClicked(p_93641_, p_93642_, p_93643_);
        }

        public List<ClientTooltipComponent> getMessageForTooltip() {
            if (this.tooltip == null) {
                this.tooltip = List.of(ClientTooltipComponent.create((FormattedCharSequence)this.getMessage().getVisualOrderText()));
            }
            return this.tooltip;
        }
    }
}

