/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.blocks;

import java.util.Optional;
import moonfather.workshop_for_handsome_adventurer.block_entities.DualTableBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.DualTableMenu;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomSecondary;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableTopSecondary;
import moonfather.workshop_for_handsome_adventurer.blocks.DualTableBaseBlock;
import moonfather.workshop_for_handsome_adventurer.blocks.SimpleTable;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.other.TableLockManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AdvancedTableBottomPrimary
extends DualTableBaseBlock
implements EntityBlock {
    private static final VoxelShape SHAPE_TOP = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0);
    private static final VoxelShape SHAPE_LEG3 = Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0);
    private static final VoxelShape SHAPE_LEG2 = Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0);
    private static final VoxelShape SHAPE_LEG4 = Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0);
    private static final VoxelShape SHAPE_TABLE_S = Shapes.or((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_LEG1, SHAPE_LEG3});
    private static final VoxelShape SHAPE_TABLE_W = Shapes.or((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_LEG1, SHAPE_LEG2});
    private static final VoxelShape SHAPE_TABLE_N = Shapes.or((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_LEG2, SHAPE_LEG4});
    private static final VoxelShape SHAPE_TABLE_E = Shapes.or((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_LEG3, SHAPE_LEG4});
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.crafting");
    public static final BooleanProperty HAS_LANTERNS = BooleanProperty.create((String)"has_lanterns");
    public static final BooleanProperty LIGHTS_ON = BooleanProperty.create((String)"is_lit");

    public AdvancedTableBottomPrimary(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)SimpleTable.HAS_INVENTORY, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_LANTERNS, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getOcclusionShape(BlockState state) {
        return this.ResolveShape((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter p_60582_, BlockPos p_60583_) {
        return this.ResolveShape((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.ResolveShape((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
    }

    private VoxelShape ResolveShape(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> SHAPE_TABLE_N;
            case Direction.WEST -> SHAPE_TABLE_W;
            case Direction.SOUTH -> SHAPE_TABLE_S;
            case Direction.EAST -> SHAPE_TABLE_E;
            default -> null;
        };
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)BEING_PLACED)).booleanValue()) {
            return true;
        }
        Block above = world.getBlockState(pos.above()).getBlock();
        if (!(above instanceof AdvancedTableTopSecondary)) {
            return false;
        }
        Block right = world.getBlockState(pos.relative(((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getCounterClockWise())).getBlock();
        return right instanceof AdvancedTableBottomSecondary;
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        ResourceLocation block = BuiltInRegistries.BLOCK.getKey((Object)this);
        String path = block.getPath();
        String wood = path.substring(path.indexOf("_left_") + 6);
        String prefix = path.substring(0, path.indexOf("dual_table_bottom_left_"));
        Optional item = BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)block.getNamespace(), (String)(prefix + "workstation_placer_" + wood)));
        if (item.isEmpty()) {
            return Items.OAK_PLANKS.getDefaultInstance();
        }
        return new ItemStack((Holder)item.get());
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (TableLockManager.isLocked(level, pos)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.workshop_for_handsome_adventurer.workshop_table_in_use", (Object[])new Object[]{TableLockManager.getPlayerName(level, pos).copy().withStyle(Style.EMPTY.withColor(-1118703))}), true);
            return InteractionResult.CONSUME;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        player.awardStat(Stats.INTERACT_WITH_CRAFTING_TABLE);
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new DualTableBlockEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return null;
    }

    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos blockPos) {
        return new SimpleMenuProvider((containerId, inventory, p_52231_) -> new DualTableMenu(containerId, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)blockPos), Registration.CRAFTING_DUAL_MENU_TYPE.get()), CONTAINER_TITLE);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SimpleTable.HAS_INVENTORY});
        builder.add(new Property[]{HAS_LANTERNS});
    }

    public void setLanternState(Level level, BlockPos pos, boolean value) {
        BlockState state1 = level.getBlockState(pos);
        BlockPos pos2 = pos.above();
        BlockState state2 = level.getBlockState(pos2);
        BlockPos pos3 = pos2.relative(((Direction)state2.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getCounterClockWise());
        BlockState state3 = level.getBlockState(pos3);
        if ((Boolean)state2.getValue((Property)HAS_LANTERNS) == value && (Boolean)state3.getValue((Property)HAS_LANTERNS) == value && (Boolean)state1.getValue((Property)HAS_LANTERNS) == value) {
            return;
        }
        level.setBlockAndUpdate(pos, (BlockState)state1.setValue((Property)HAS_LANTERNS, (Comparable)Boolean.valueOf(value)));
        level.setBlockAndUpdate(pos2, (BlockState)((BlockState)state2.setValue((Property)HAS_LANTERNS, (Comparable)Boolean.valueOf(value))).setValue((Property)LIGHTS_ON, (Comparable)Boolean.valueOf(value)));
        level.setBlockAndUpdate(pos3, (BlockState)((BlockState)state3.setValue((Property)HAS_LANTERNS, (Comparable)Boolean.valueOf(value))).setValue((Property)LIGHTS_ON, (Comparable)Boolean.valueOf(value)));
    }

    @Override
    protected void toggleLights(BlockState state, Level level, BlockPos pos) {
        BlockState state2;
        BlockPos pos2;
        level.setBlockAndUpdate(pos2, (BlockState)state2.setValue((Property)LIGHTS_ON, (Comparable)Boolean.valueOf((Boolean)(state2 = level.getBlockState(pos2 = pos.above())).getValue((Property)LIGHTS_ON) == false)));
        pos2 = pos2.relative(((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getCounterClockWise());
        state2 = level.getBlockState(pos2);
        level.setBlockAndUpdate(pos2, (BlockState)state2.setValue((Property)LIGHTS_ON, (Comparable)Boolean.valueOf((Boolean)state2.getValue((Property)LIGHTS_ON) == false)));
    }
}

