/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.blocks;

import moonfather.workshop_for_handsome_adventurer.Constants;
import moonfather.workshop_for_handsome_adventurer.block_entities.BookShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BookShelf
extends ToolRack {
    private static final int INITIAL_BOOK_COUNT = 12;
    private final MutableComponent NotABookMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.invalid_item_for_book_shelf");
    public static final BooleanProperty[] SLOT_OCCUPIED = new BooleanProperty[20];

    public BookShelf(String subType, BlockBehaviour.Properties properties) {
        super(12, "book_shelf", subType, properties);
        this.registedDefaultState();
    }

    protected abstract int numberOfBooksInARow();

    protected abstract int numberOfRows();

    protected boolean singleRowIsTop() {
        return true;
    }

    public static int getBookShelfSlot(BookShelf block, BlockHitResult blockHitResult) {
        return block.getTargetedSlot(blockHitResult);
    }

    @Override
    protected int getTargetedSlot(BlockHitResult blockHitResult) {
        int aboveThisRow;
        double frac = blockHitResult.getLocation().y - (double)blockHitResult.getBlockPos().getY();
        if (this.numberOfRows() == 2) {
            aboveThisRow = frac >= 0.5 ? 0 : this.numberOfBooksInARow();
        } else {
            aboveThisRow = 0;
            if (frac > 0.5 && !this.singleRowIsTop() || frac < 0.5 && this.singleRowIsTop()) {
                return -1;
            }
        }
        int integral = (int)blockHitResult.getLocation().z;
        frac = (blockHitResult.getLocation().z - (double)integral) * (double)blockHitResult.getDirection().getStepX();
        integral = (int)blockHitResult.getLocation().x;
        frac -= (blockHitResult.getLocation().x - (double)integral) * (double)blockHitResult.getDirection().getStepZ();
        while (frac < 0.0) {
            frac += 1.0;
        }
        while (frac > 1.0) {
            frac -= 1.0;
        }
        int horizontal = this.numberOfBooksInARow() - 1 - (int)Math.floor(frac * (double)this.numberOfBooksInARow());
        return aboveThisRow + horizontal;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        int slot = this.getTargetedSlot(blockHitResult);
        if (slot >= this.itemCount) {
            slot -= this.itemCount;
        }
        if (slot == -1) {
            return InteractionResult.CONSUME;
        }
        BookShelfBlockEntity BE = (BookShelfBlockEntity)level.getBlockEntity(pos);
        ItemStack existing = BE.GetItem(slot);
        ItemStack itemInMainHand = player.getMainHandItem();
        ItemStack itemInOffHand = player.getOffhandItem();
        if (existing.isEmpty()) {
            if (this.canDepositItem(itemInMainHand)) {
                BookShelf.doPlaceBookOntoShelf(player, itemInMainHand, slot, BE, level, pos, blockState);
            } else if (this.canDepositItem(itemInOffHand)) {
                BookShelf.doPlaceBookOntoShelf(player, itemInOffHand, slot, BE, level, pos, blockState);
            } else if (!itemInMainHand.isEmpty() || !itemInOffHand.isEmpty()) {
                player.displayClientMessage((Component)this.NotABookMessage, true);
            }
        } else if (!existing.isEmpty() && itemInMainHand.isEmpty()) {
            BookShelf.doPickBookFromShelf(player, InteractionHand.MAIN_HAND, existing, slot, BE, level, pos, blockState);
        } else if (!existing.isEmpty() && !itemInMainHand.isEmpty() && itemInOffHand.isEmpty()) {
            BookShelf.doPickBookFromShelf(player, InteractionHand.OFF_HAND, existing, slot, BE, level, pos, blockState);
        }
        return InteractionResult.CONSUME;
    }

    private static void doPickBookFromShelf(Player player, InteractionHand hand, ItemStack bookInShelfSlot, int slot, BookShelfBlockEntity BE, Level level, BlockPos pos, BlockState blockState) {
        player.setItemInHand(hand, bookInShelfSlot);
        BE.ClearItem(slot);
        player.playSound(SoundEvents.ITEM_PICKUP, 0.5f, 1.0f);
        level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)BookShelf.getSlotProperty(slot), (Comparable)Boolean.valueOf(false)));
    }

    private static void doPlaceBookOntoShelf(Player player, ItemStack itemToStore, int slot, BookShelfBlockEntity BE, Level level, BlockPos pos, BlockState blockState) {
        ItemStack toStore = itemToStore.copy();
        toStore.setCount(1);
        BE.DepositItem(slot, toStore);
        itemToStore.shrink(1);
        player.playSound(SoundEvents.BOOK_PUT, 0.5f, 0.7f);
        level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)BookShelf.getSlotProperty(slot), (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected boolean canDepositItem(ItemStack mainHandItem) {
        return mainHandItem.is(ItemTags.BOOKSHELF_BOOKS) || mainHandItem.is(Constants.Tags.COMMON_BOOKS);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        BookShelfBlockEntity BE = new BookShelfBlockEntity(pos, blockState);
        BE.setCapacity(this.getBookCapacity());
        return BE;
    }

    private int getBookCount() {
        return this.numberOfRows() * this.numberOfBooksInARow();
    }

    private int getBookCapacity() {
        return Math.max(this.numberOfRows() * this.numberOfBooksInARow(), 8);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        if (SLOT_OCCUPIED[0] == null) {
            int slot_count = this.getBookCapacity();
            for (int i = 0; i < slot_count; ++i) {
                BookShelf.SLOT_OCCUPIED[i] = BooleanProperty.create((String)("slot_" + i + "_occupied"));
            }
        }
        for (int i = 0; i < this.getBookCount(); ++i) {
            builder.add(new Property[]{SLOT_OCCUPIED[i]});
        }
    }

    private static BooleanProperty getSlotProperty(int slot) {
        return SLOT_OCCUPIED[slot];
    }

    private void registedDefaultState() {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH);
        for (int i = 0; i < this.getBookCount(); ++i) {
            state = (BlockState)state.setValue((Property)BookShelf.getSlotProperty(i), (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(state);
    }

    public static class TopWithLanterns
    extends BookShelf {
        public static final BooleanProperty LIGHTS_ON = BooleanProperty.create((String)"is_lit");
        private static final VoxelShape SHAPE_FRAME1N = Block.box((double)0.0, (double)7.5, (double)0.0, (double)16.0, (double)16.0, (double)7.0);
        private static final VoxelShape SHAPE_FRAME1E = Block.box((double)9.0, (double)7.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1S = Block.box((double)0.0, (double)7.5, (double)9.0, (double)16.0, (double)16.0, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1W = Block.box((double)0.0, (double)7.5, (double)0.0, (double)7.0, (double)16.0, (double)16.0);
        private static final VoxelShape SHAPE_LAMPS1N = Block.box((double)2.5, (double)3.0, (double)0.0, (double)13.5, (double)7.5, (double)4.0);
        private static final VoxelShape SHAPE_LAMPS1E = Block.box((double)12.0, (double)3.0, (double)2.5, (double)16.0, (double)7.5, (double)13.5);
        private static final VoxelShape SHAPE_LAMPS1S = Block.box((double)2.5, (double)3.0, (double)12.0, (double)13.5, (double)7.5, (double)16.0);
        private static final VoxelShape SHAPE_LAMPS1W = Block.box((double)0.0, (double)3.0, (double)2.5, (double)4.0, (double)7.5, (double)13.5);

        public TopWithLanterns(String type, BlockBehaviour.Properties properties) {
            super(type, properties.lightLevel(TopWithLanterns::getLightLevel));
        }

        @Override
        protected int numberOfBooksInARow() {
            return 4;
        }

        @Override
        protected int numberOfRows() {
            return 1;
        }

        private static int getLightLevel(BlockState state) {
            return (Boolean)state.getValue((Property)LIGHTS_ON) != false ? 12 : 0;
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{LIGHTS_ON});
        }

        @Override
        protected void PrepareListOfShapes() {
            this.shapes.clear();
            this.shapes.put(Direction.NORTH, Shapes.or((VoxelShape)SHAPE_FRAME1N, (VoxelShape)SHAPE_LAMPS1N));
            this.shapes.put(Direction.EAST, Shapes.or((VoxelShape)SHAPE_FRAME1E, (VoxelShape)SHAPE_LAMPS1E));
            this.shapes.put(Direction.SOUTH, Shapes.or((VoxelShape)SHAPE_FRAME1S, (VoxelShape)SHAPE_LAMPS1S));
            this.shapes.put(Direction.WEST, Shapes.or((VoxelShape)SHAPE_FRAME1W, (VoxelShape)SHAPE_LAMPS1W));
        }

        @Override
        public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            int slot = this.getTargetedSlot(blockHitResult);
            if (slot == -1) {
                level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)LIGHTS_ON, (Comparable)Boolean.valueOf((Boolean)blockState.getValue((Property)LIGHTS_ON) == false)));
                return InteractionResult.CONSUME;
            }
            return super.useWithoutItem(blockState, level, pos, player, blockHitResult);
        }
    }

    public static class TopSimple
    extends BookShelf {
        private static final VoxelShape SHAPE_FRAME1N = Block.box((double)0.0, (double)7.5, (double)0.0, (double)16.0, (double)16.0, (double)7.0);
        private static final VoxelShape SHAPE_FRAME1E = Block.box((double)9.0, (double)7.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1S = Block.box((double)0.0, (double)7.5, (double)9.0, (double)16.0, (double)16.0, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1W = Block.box((double)0.0, (double)7.5, (double)0.0, (double)7.0, (double)16.0, (double)16.0);

        public TopSimple(String type, BlockBehaviour.Properties properties) {
            super(type, properties);
        }

        @Override
        protected int numberOfBooksInARow() {
            return 4;
        }

        @Override
        protected int numberOfRows() {
            return 1;
        }

        @Override
        protected void PrepareListOfShapes() {
            this.shapes.clear();
            this.shapes.put(Direction.NORTH, SHAPE_FRAME1N);
            this.shapes.put(Direction.EAST, SHAPE_FRAME1E);
            this.shapes.put(Direction.SOUTH, SHAPE_FRAME1S);
            this.shapes.put(Direction.WEST, SHAPE_FRAME1W);
        }
    }

    public static class Dual
    extends BookShelf {
        private static final VoxelShape SHAPE_FRAME1N = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.99, (double)7.0);
        private static final VoxelShape SHAPE_FRAME1E = Block.box((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)15.99, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1S = Block.box((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)15.99, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1W = Block.box((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)15.99, (double)16.0);

        public Dual(String type, BlockBehaviour.Properties properties) {
            super(type, properties);
        }

        @Override
        protected int numberOfBooksInARow() {
            return 4;
        }

        @Override
        protected int numberOfRows() {
            return 2;
        }

        @Override
        protected void PrepareListOfShapes() {
            this.shapes.clear();
            this.shapes.put(Direction.NORTH, SHAPE_FRAME1N);
            this.shapes.put(Direction.EAST, SHAPE_FRAME1E);
            this.shapes.put(Direction.SOUTH, SHAPE_FRAME1S);
            this.shapes.put(Direction.WEST, SHAPE_FRAME1W);
        }
    }
}

