/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.blocks;

import moonfather.workshop_for_handsome_adventurer.block_entities.DiscShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiscShelf
extends PotionShelf {
    public static final int SLOT_COUNT = 9;
    private static final VoxelShape SHAPE_FRAME1N = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)2.0);
    private static final VoxelShape SHAPE_FRAME1E = Block.box((double)14.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_FRAME1S = Block.box((double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_FRAME1W = Block.box((double)0.0, (double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_FRAME2N = Block.box((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)7.0, (double)5.0);
    private static final VoxelShape SHAPE_FRAME2E = Block.box((double)11.0, (double)1.0, (double)1.0, (double)14.0, (double)7.0, (double)15.0);
    private static final VoxelShape SHAPE_FRAME2S = Block.box((double)1.0, (double)1.0, (double)11.0, (double)15.0, (double)7.0, (double)14.0);
    private static final VoxelShape SHAPE_FRAME2W = Block.box((double)2.0, (double)1.0, (double)1.0, (double)5.0, (double)7.0, (double)15.0);

    public DiscShelf(BlockBehaviour.Properties properties) {
        super(9, "disc_shelf", null, properties);
        this.ShelfMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_invalid_item2");
        this.MaxedMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_slot_maxed");
        this.RemainingItemsKey = "message.workshop_for_handsome_adventurer.shelf_remaining_items2";
        this.NotTheSameTypeMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_wrong_potion2");
        this.HintMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_hint2");
    }

    @Override
    protected boolean canDepositItem(@NotNull ItemStack mainHandItem) {
        if (mainHandItem.isEmpty()) {
            return true;
        }
        return mainHandItem.is(Tags.Items.MUSIC_DISCS) || mainHandItem.is(ItemTags.CREEPER_DROP_MUSIC_DISCS);
    }

    @Override
    protected boolean canInteractWithOffhand() {
        return true;
    }

    @Override
    public int getShelfSlot(BlockHitResult blockHitResult) {
        return DiscShelf.getDiscShelfSlot(blockHitResult);
    }

    public static int getDiscShelfSlot(BlockHitResult blockHitResult) {
        return DiscShelf.getDiscShelfSlot((HitResult)blockHitResult, blockHitResult.getBlockPos(), blockHitResult.getDirection());
    }

    public static int getDiscShelfSlot(HitResult hitResult, BlockPos blockPos, Direction direction) {
        int aboveThisRow = 0;
        double frac = hitResult.getLocation().y - (double)blockPos.getY();
        if (frac < 0.6875) {
            aboveThisRow = 3;
        }
        if (frac < 0.4375) {
            aboveThisRow = 6;
        }
        int integral = (int)hitResult.getLocation().z;
        frac = (hitResult.getLocation().z - (double)integral) * (double)direction.getStepX();
        integral = (int)hitResult.getLocation().x;
        int horizontalIndex = (frac -= (hitResult.getLocation().x - (double)integral) * (double)direction.getStepZ()) >= -0.3333333333333333 && frac < 0.0 || frac >= 0.6666666666666666 && frac < 1.0 ? 0 : (frac >= 0.3333333333333333 && frac < 0.6666666666666666 || frac - 1.0 >= 0.3333333333333333 && frac - 1.0 < 0.6666666666666666 || frac + 1.0 >= 0.3333333333333333 && frac + 1.0 < 0.6666666666666666 ? 1 : 2);
        return aboveThisRow + horizontalIndex;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (blockHitResult.getDirection().equals((Object)Direction.UP) || blockHitResult.getDirection().equals((Object)Direction.DOWN)) {
            return InteractionResult.PASS;
        }
        return super.useWithoutItem(blockState, level, pos, player, blockHitResult);
    }

    @Override
    protected void PrepareListOfShapes() {
        this.shapes.clear();
        this.shapes.put(Direction.NORTH, Shapes.or((VoxelShape)SHAPE_FRAME1N, (VoxelShape)SHAPE_FRAME2N));
        this.shapes.put(Direction.EAST, Shapes.or((VoxelShape)SHAPE_FRAME1E, (VoxelShape)SHAPE_FRAME2E));
        this.shapes.put(Direction.SOUTH, Shapes.or((VoxelShape)SHAPE_FRAME1S, (VoxelShape)SHAPE_FRAME2S));
        this.shapes.put(Direction.WEST, Shapes.or((VoxelShape)SHAPE_FRAME1W, (VoxelShape)SHAPE_FRAME2W));
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new DiscShelfBlockEntity(pos, blockState);
    }
}

