/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.blocks;

import moonfather.workshop_for_handsome_adventurer.blocks.DualTableBaseBlock;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.integration.TetraCompatibleToolRackHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class DualToolRack
extends ToolRack {
    private static final VoxelShape SHAPE_PLANK1N = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0);
    private static final VoxelShape SHAPE_PLANK1E = Block.box((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_PLANK1S = Block.box((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_PLANK1W = Block.box((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_PLANK2N = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    private static final VoxelShape SHAPE_PLANK2E = Block.box((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_PLANK2S = Block.box((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_PLANK2W = Block.box((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);

    public DualToolRack(int itemCount, String type, BlockBehaviour.Properties properties) {
        super(itemCount, type, properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER));
    }

    public static ToolRack create(int itemCount, String type, BlockBehaviour.Properties properties) {
        if (ModList.get().isLoaded("tetra")) {
            return TetraCompatibleToolRackHelper.create(true, itemCount, type, properties);
        }
        return new DualToolRack(itemCount, type, properties);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.DOUBLE_BLOCK_HALF});
        builder.add(new Property[]{DualTableBaseBlock.BEING_PLACED});
        super.createBlockStateDefinition(builder);
    }

    @Override
    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos target = context.getClickedPos();
        Level level = context.getLevel();
        BlockPos below = target.below();
        if (target.getY() <= level.getMinY() || !level.getBlockState(below).canBeReplaced(context)) {
            return null;
        }
        BlockPos back = target.relative(context.getClickedFace().getOpposite());
        if (!level.getBlockState(back).isFaceSturdy((BlockGetter)level, back, context.getClickedFace())) {
            return null;
        }
        if (!level.getBlockState(back = back.below()).isFaceSturdy((BlockGetter)level, back, context.getClickedFace())) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)DualTableBaseBlock.BEING_PLACED, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack itemStack) {
        level.setBlock(pos.below(), (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)DualTableBaseBlock.BEING_PLACED, (Comparable)Boolean.valueOf(false)), 3);
        level.setBlock(pos, (BlockState)state.setValue((Property)DualTableBaseBlock.BEING_PLACED, (Comparable)Boolean.valueOf(false)), 3);
    }

    @Override
    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, orientation, movedByPiston);
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos back = pos.relative((Direction)state.getValue((Property)FACING));
        BlockState blockstate = levelReader.getBlockState(back);
        if (!blockstate.isFaceSturdy((BlockGetter)levelReader, back, ((Direction)state.getValue((Property)FACING)).getOpposite())) {
            return false;
        }
        if (!((Boolean)state.getValue((Property)DualTableBaseBlock.BEING_PLACED)).booleanValue()) {
            if (state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
                return levelReader.getBlockState(pos.above()).is((Block)this);
            }
            return levelReader.getBlockState(pos.below()).is((Block)this);
        }
        return true;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Override
    public VoxelShape getOcclusionShape(BlockState state) {
        return DualToolRack.resolveShape((Direction)state.getValue(ToolRack.FACING), (DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF));
    }

    @Override
    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter p_60582_, BlockPos p_60583_) {
        return DualToolRack.resolveShape((Direction)state.getValue(ToolRack.FACING), (DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return DualToolRack.resolveShape((Direction)state.getValue(ToolRack.FACING), (DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF));
    }

    @Override
    public VoxelShape getInteractionShape(BlockState state, BlockGetter p_60548_, BlockPos p_60549_) {
        return DualToolRack.resolveShape((Direction)state.getValue(ToolRack.FACING), (DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF));
    }

    private static VoxelShape resolveShape(Direction direction, DoubleBlockHalf half) {
        if (direction.equals((Object)Direction.NORTH) && half.equals((Object)DoubleBlockHalf.LOWER)) {
            return SHAPE_PLANK1N;
        }
        if (direction.equals((Object)Direction.WEST) && half.equals((Object)DoubleBlockHalf.LOWER)) {
            return SHAPE_PLANK1W;
        }
        if (direction.equals((Object)Direction.EAST) && half.equals((Object)DoubleBlockHalf.LOWER)) {
            return SHAPE_PLANK1E;
        }
        if (direction.equals((Object)Direction.SOUTH) && half.equals((Object)DoubleBlockHalf.LOWER)) {
            return SHAPE_PLANK1S;
        }
        if (direction.equals((Object)Direction.NORTH) && half.equals((Object)DoubleBlockHalf.UPPER)) {
            return SHAPE_PLANK2N;
        }
        if (direction.equals((Object)Direction.WEST) && half.equals((Object)DoubleBlockHalf.UPPER)) {
            return SHAPE_PLANK2W;
        }
        if (direction.equals((Object)Direction.EAST) && half.equals((Object)DoubleBlockHalf.UPPER)) {
            return SHAPE_PLANK2E;
        }
        if (direction.equals((Object)Direction.SOUTH) && half.equals((Object)DoubleBlockHalf.UPPER)) {
            return SHAPE_PLANK2S;
        }
        return null;
    }
}

