/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.blocks;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import moonfather.workshop_for_handsome_adventurer.CommonConfig;
import moonfather.workshop_for_handsome_adventurer.Constants;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.IBlockWithCleverHoverText;
import moonfather.workshop_for_handsome_adventurer.integration.PackingTape;
import moonfather.workshop_for_handsome_adventurer.integration.TetraCompatibleToolRackHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ToolRack
extends Block
implements EntityBlock,
IBlockWithCleverHoverText {
    protected final int itemCount;
    protected MutableComponent Tooltip1;
    protected MutableComponent Tooltip2;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE_PLANK1N = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    private static final VoxelShape SHAPE_PLANK1E = Block.box((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_PLANK1S = Block.box((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_PLANK1W = Block.box((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);
    protected final Map<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>(4);
    private final MutableComponent RackMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.invalid_item_for_rack");

    public static BlockBehaviour.Properties getDefaultProperties() {
        return BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava().mapColor(MapColor.COLOR_BROWN).pushReaction(PushReaction.DESTROY);
    }

    public ToolRack(int itemCount, String type, BlockBehaviour.Properties properties) {
        this(itemCount, "tool_rack", type, properties);
    }

    public ToolRack(int itemCount, String mainType, @Nullable String subType, BlockBehaviour.Properties properties) {
        super(properties);
        this.itemCount = itemCount;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH));
        this.PrepareListOfShapes();
        String translationKeyStructure = "block.{0}.{1}_{2}.tooltip{3}";
        if (subType == null) {
            translationKeyStructure = "block.{0}.{1}.tooltip{3}";
        }
        String translationKey = MessageFormat.format(translationKeyStructure, "workshop_for_handsome_adventurer", mainType, subType, 1);
        this.Tooltip1 = Component.translatable((String)translationKey).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0xAA77DD));
        translationKey = MessageFormat.format(translationKeyStructure, "workshop_for_handsome_adventurer", mainType, subType, 2);
        this.Tooltip2 = Component.translatable((String)translationKey).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0xAA77DD));
    }

    public static ToolRack create(int itemCount, String type, BlockBehaviour.Properties properties) {
        if (ModList.get().isLoaded("tetra")) {
            return TetraCompatibleToolRackHelper.create(false, itemCount, type, properties);
        }
        return new ToolRack(itemCount, type, properties);
    }

    public VoxelShape getOcclusionShape(BlockState state) {
        return this.shapes.get(state.getValue(FACING));
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter p_60582_, BlockPos p_60583_) {
        return this.shapes.get(state.getValue(FACING));
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.shapes.get(state.getValue(FACING));
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter p_60548_, BlockPos p_60549_) {
        return this.shapes.get(state.getValue(FACING));
    }

    @Override
    public List<Component> getTooltipLines() {
        ArrayList<Component> result = new ArrayList<Component>(2);
        result.add((Component)this.Tooltip1);
        result.add((Component)this.Tooltip2);
        return result;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace() == Direction.DOWN || context.getClickedFace() == Direction.UP) {
            return null;
        }
        BlockState result = (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace().getOpposite());
        if (this.canSurvive(result, (LevelReader)context.getLevel(), context.getClickedPos())) {
            return result;
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction d = ((Direction)state.getValue(FACING)).getOpposite();
        BlockPos target = pos.relative(d.getOpposite());
        return world.getBlockState(target).isFaceSturdy((BlockGetter)world, target, d);
    }

    protected void PrepareListOfShapes() {
        this.shapes.put(Direction.NORTH, SHAPE_PLANK1N);
        this.shapes.put(Direction.EAST, SHAPE_PLANK1E);
        this.shapes.put(Direction.SOUTH, SHAPE_PLANK1S);
        this.shapes.put(Direction.WEST, SHAPE_PLANK1W);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        if (!blockState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) || blockState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER) {
            return new ToolRackBlockEntity(pos, blockState);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return null;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, orientation, movedByPiston);
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (blockState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && blockState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            BlockPos above = pos.above();
            return this.useWithoutItem(level.getBlockState(above), level, above, player, blockHitResult.withPosition(above));
        }
        boolean doOffhand = (Boolean)CommonConfig.OffhandInteractsWithToolRack.get();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        int slot = this.getTargetedSlot(blockHitResult);
        if (slot >= this.itemCount) {
            slot -= this.itemCount;
        }
        ToolRackBlockEntity BE = (ToolRackBlockEntity)level.getBlockEntity(pos);
        ItemStack existing = BE.GetItem(slot);
        ItemStack itemInMainHand = player.getMainHandItem();
        ItemStack itemInOffHand = player.getOffhandItem();
        if (existing.isEmpty() && !itemInMainHand.isEmpty()) {
            if (!this.canDepositItem(itemInMainHand)) {
                player.displayClientMessage((Component)this.RackMessage, true);
                return InteractionResult.CONSUME;
            }
            ItemStack toStore = itemInMainHand.copy();
            toStore.setCount(1);
            BE.DepositItem(slot, toStore);
            itemInMainHand.shrink(1);
            player.playSound(SoundEvents.WOOD_PLACE, 0.5f, 0.7f);
        } else if (!existing.isEmpty() || !itemInMainHand.isEmpty() || doOffhand && !itemInOffHand.isEmpty()) {
            if (existing.isEmpty() && itemInMainHand.isEmpty() && doOffhand && !itemInOffHand.isEmpty()) {
                if (!this.canDepositItem(itemInOffHand)) {
                    player.displayClientMessage((Component)this.RackMessage, true);
                    return InteractionResult.CONSUME;
                }
                ItemStack toStore = itemInOffHand.copy();
                toStore.setCount(1);
                BE.DepositItem(slot, toStore);
                itemInOffHand.shrink(1);
                player.playSound(SoundEvents.WOOD_PLACE, 0.5f, 0.7f);
            } else if (!existing.isEmpty() && itemInMainHand.isEmpty() && itemInOffHand.isEmpty() && existing.has(DataComponents.BLOCKS_ATTACKS)) {
                player.setItemInHand(InteractionHand.OFF_HAND, existing);
                BE.ClearItem(slot);
                player.playSound(SoundEvents.ITEM_PICKUP, 0.5f, 1.0f);
            } else if (!existing.isEmpty() && itemInMainHand.isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, existing);
                BE.ClearItem(slot);
                player.playSound(SoundEvents.ITEM_PICKUP, 0.5f, 1.0f);
            } else if (!existing.isEmpty() && !itemInMainHand.isEmpty() && doOffhand && itemInOffHand.isEmpty()) {
                if (!itemInMainHand.has(DataComponents.BLOCKS_ATTACKS)) {
                    player.setItemInHand(InteractionHand.OFF_HAND, existing);
                } else {
                    player.setItemInHand(InteractionHand.OFF_HAND, itemInMainHand);
                    player.setItemInHand(InteractionHand.MAIN_HAND, existing);
                }
                BE.ClearItem(slot);
                player.playSound(SoundEvents.ITEM_PICKUP, 0.5f, 1.0f);
            }
        }
        level.sendBlockUpdated(pos, blockState, blockState, 2);
        return InteractionResult.CONSUME;
    }

    public static int getToolRackSlot(ToolRack block, BlockHitResult blockHitResult) {
        return block.getTargetedSlot(blockHitResult);
    }

    protected int getTargetedSlot(BlockHitResult blockHitResult) {
        int aboveThisRow = 0;
        double frac = blockHitResult.getLocation().y - (double)blockHitResult.getBlockPos().getY();
        if (frac >= 0.3125) {
            aboveThisRow = 0;
        }
        if (frac < 0.3125 && frac >= -0.3125) {
            aboveThisRow = 2;
        }
        if (frac < -0.3125 && frac >= -0.9375) {
            aboveThisRow = 4;
        }
        int integral = (int)blockHitResult.getLocation().z;
        frac = (blockHitResult.getLocation().z - (double)integral) * (double)blockHitResult.getDirection().getStepX();
        integral = (int)blockHitResult.getLocation().x;
        boolean left = (frac -= (blockHitResult.getLocation().x - (double)integral) * (double)blockHitResult.getDirection().getStepZ()) >= -0.5 && frac < 0.0 || frac >= 0.5;
        return aboveThisRow + (left ? 0 : 1);
    }

    protected boolean canDepositItem(ItemStack mainHandItem) {
        if (mainHandItem == null || mainHandItem.isEmpty()) {
            return true;
        }
        if (mainHandItem.is(Constants.Tags.NOT_ALLOWED_ON_TOOLRACK) || mainHandItem.is(ItemTags.BOOKSHELF_BOOKS) || mainHandItem.is(Constants.Tags.COMMON_BOOKS)) {
            return false;
        }
        if (mainHandItem.has(DataComponents.BLOCKS_ATTACKS)) {
            return true;
        }
        if (mainHandItem.getMaxStackSize() > 1 && !mainHandItem.getItem().equals(Items.LEAD) && !PackingTape.isTape(mainHandItem)) {
            return false;
        }
        if (mainHandItem.getItem() instanceof BlockItem || mainHandItem.has(DataComponents.EQUIPPABLE)) {
            return false;
        }
        if (mainHandItem.get(DataComponents.FOOD) != null || mainHandItem.getItem() instanceof BucketItem || mainHandItem.getItem() instanceof MinecartItem || mainHandItem.getItem() instanceof BoatItem) {
            return false;
        }
        return mainHandItem.get(DataComponents.POTION_CONTENTS) == null;
    }
}

