/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources;

import dev.lukebemish.dynamicassetgenerator.api.DataResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.AssetResourceCache;
import java.io.IOException;
import java.io.InputStream;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.AssetReader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;

public class DAGResourceReader
extends AssetReader {
    private final PackType packType;
    private final String namespace;
    private ResourceCache cache = null;
    private ResourceGenerationContext context = null;

    public DAGResourceReader(PackType packType, String namespace) {
        this.packType = packType;
        this.namespace = namespace;
    }

    private void initContext() {
        if (this.context == null) {
            this.cache = this.packType.equals((Object)PackType.SERVER_DATA) ? ResourceCache.register((ResourceCache)new DataResourceCache(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)"data"))) : ResourceCache.register((ResourceCache)new AssetResourceCache(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)"assets")));
            this.context = this.cache.makeContext(true).withResourceSource(ResourceGenerationContext.ResourceSource.filtered(s -> true, (PackType)this.packType));
        }
    }

    @Override
    public InputStream getStream(ResourceLocation location) {
        this.initContext();
        IoSupplier sup = this.context.getResourceSource().getResource(location);
        if (sup != null) {
            try {
                return (InputStream)sup.get();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

