/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.CustomTripletSupport;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeCommonManager;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.config.DynamicAssetCommonConfig;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public class WoodTypeLister {
    private static List<String> ids = null;
    private static List<String> idsWithSpecials = null;
    private static final HashMap<String, String> woodToHostMap = new HashMap();
    private static final List<ResourceLocation> dupeIds = new ArrayList<ResourceLocation>();

    public static void reset() {
        ids = null;
    }

    public static List<String> getWoodIds(boolean includeSpecials) {
        WoodTypeLister.generateIfNeeded();
        return includeSpecials ? idsWithSpecials : ids;
    }

    public static List<String> getWoodIds() {
        WoodTypeLister.generateIfNeeded();
        return idsWithSpecials;
    }

    public static void generateIfNeeded() {
        if (ids == null) {
            ids = new ArrayList<String>();
            idsWithSpecials = new ArrayList<String>(ids);
            if (!DynamicAssetCommonConfig.masterLeverOn()) {
                return;
            }
            Stopwatch s = Stopwatch.createStarted();
            ids.add("acacia");
            woodToHostMap.put("acacia", "minecraft");
            ids.add("bamboo");
            woodToHostMap.put("bamboo", "minecraft");
            ids.add("pale_oak");
            woodToHostMap.put("pale_oak", "minecraft");
            ids.add("crimson");
            woodToHostMap.put("crimson", "minecraft");
            ids.add("warped");
            woodToHostMap.put("warped", "minecraft");
            String mc = "minecraft";
            String planks = "_planks";
            String slab = "_slab";
            String vertical = "vertical";
            String LOG1 = "stripped_";
            String LOG2 = "_log";
            for (ResourceLocation id : BuiltInRegistries.BLOCK.keySet()) {
                if (id.getNamespace().equals("minecraft") || !id.getPath().endsWith("_planks") || id.getPath().contains("vertical")) continue;
                String wood = id.getPath().replace("_planks", "");
                if (DynamicAssetCommonConfig.isBlackListed(id.getNamespace(), wood) || !BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath().replace("_planks", "_slab")))) continue;
                if (!ids.contains(wood) && !Registration.woodTypes.contains(wood)) {
                    String substitute;
                    if (!BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("stripped_" + wood + "_log"))) && ((substitute = DynamicAssetCommonConfig.getLogRecipeSubstitution(wood)) == null || !BuiltInRegistries.BLOCK.containsKey(ResourceLocation.parse((String)substitute)))) continue;
                    ids.add(wood);
                    woodToHostMap.put(wood, id.getNamespace());
                    continue;
                }
                if (!BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("stripped_" + wood + "_log")))) continue;
                dupeIds.add(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)wood));
            }
            s.stop();
            idsWithSpecials = new ArrayList<String>(ids);
            for (WoodTypeCommonManager.WoodSet woodSet : WoodTypeCommonManager.getWoodSetsWithDumbassNames()) {
                String substitute;
                if (!BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)woodSet.modId(), (String)woodSet.planks())) || !BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)woodSet.modId(), (String)woodSet.slab())) || !BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)woodSet.modId(), (String)woodSet.log())) && ((substitute = DynamicAssetCommonConfig.getLogRecipeSubstitution(woodSet.planks())) == null || !BuiltInRegistries.BLOCK.containsKey(ResourceLocation.parse((String)substitute)))) continue;
                idsWithSpecials.add(CustomTripletSupport.addPrefixTo(woodSet.planks()));
                woodToHostMap.put(CustomTripletSupport.addPrefixTo(woodSet.planks()), woodSet.modId());
            }
        }
    }

    public static String getHostMod(String wood) {
        return woodToHostMap.get(wood);
    }

    public static List<ResourceLocation> getDuplicateWoods() {
        return dupeIds;
    }
}

