/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources.texture_finder;

import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.AssetResourceCache;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.texture_finder.ITextureFinder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;

public class TextureAutoFinderDAG
implements ITextureFinder {
    private static final Pattern PATTERN_IN_BLOCKSTATE = Pattern.compile("\"model\"\\s*:\\s*\"[a-z0-9_]+:(.+?)\"");
    private static final Pattern PATTERN_IN_MODEL_ALL = Pattern.compile("\"all\"\\s*:\\s*\"[a-z0-9_]+:(.+?)\"");
    private static final Pattern PATTERN_IN_MODEL_SIDE = Pattern.compile("\"side\"\\s*:\\s*\"[a-z0-9_]+:(.+?)\"");
    private static final Map<String, String> PATH_CACHE = new HashMap<String, String>();
    private static final Map<String, AssetResourceCache> CACHES = new HashMap<String, AssetResourceCache>();
    private static final Map<String, ResourceGenerationContext> CONTEXTS = new HashMap<String, ResourceGenerationContext>();

    public static ITextureFinder create() {
        return new TextureAutoFinderDAG();
    }

    @Override
    public String getTexturePathForPlanks(String modId, String wood, String blockNameTemplate) {
        return TextureAutoFinderDAG.getTexturePathInternal(modId, wood, blockNameTemplate, "all");
    }

    @Override
    public String getTexturePathForLogs(String modId, String wood, String blockNameTemplate) {
        return TextureAutoFinderDAG.getTexturePathInternal(modId, wood, blockNameTemplate, "side");
    }

    private static String getTexturePathInternal(String modId, String wood, String blockTemplate, String textureNameInModelFile) {
        String key = "%s:%s/%s".formatted(modId, wood, textureNameInModelFile);
        if (PATH_CACHE.containsKey(key)) {
            return PATH_CACHE.get(key);
        }
        ResourceGenerationContext context = TextureAutoFinderDAG.getContext(modId);
        try {
            ResourceLocation rl1 = ResourceLocation.fromNamespaceAndPath((String)modId, (String)("blockstates/" + blockTemplate.formatted(wood) + ".json"));
            IoSupplier sup1 = context.getResourceSource().getResource(rl1);
            BufferedReader br1 = new BufferedReader(new InputStreamReader((InputStream)sup1.get()));
            String file1 = br1.lines().collect(Collectors.joining("\n"));
            Matcher m1 = PATTERN_IN_BLOCKSTATE.matcher(file1);
            m1.find();
            String path1 = m1.group(1);
            ResourceLocation rl2 = ResourceLocation.fromNamespaceAndPath((String)modId, (String)("models/" + path1 + ".json"));
            IoSupplier sup2 = context.getResourceSource().getResource(rl2);
            BufferedReader br2 = new BufferedReader(new InputStreamReader((InputStream)sup2.get()));
            String file2 = br2.lines().collect(Collectors.joining("\n"));
            Matcher m2 = (textureNameInModelFile.equals("all") ? PATTERN_IN_MODEL_ALL : PATTERN_IN_MODEL_SIDE).matcher(file2);
            m2.find();
            String result = m2.group(1);
            PATH_CACHE.put(key, result);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static AssetResourceCache getCache(String namespace) {
        if (CACHES.containsKey(namespace)) {
            return CACHES.get(namespace);
        }
        AssetResourceCache newOne = (AssetResourceCache)ResourceCache.register((ResourceCache)new AssetResourceCache(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"assets")));
        CACHES.put(namespace, newOne);
        newOne.reset(newOne.makeContext(false));
        return newOne;
    }

    private static ResourceGenerationContext getContext(String namespace) {
        if (CONTEXTS.containsKey(namespace)) {
            return CONTEXTS.get(namespace);
        }
        AssetResourceCache cache = TextureAutoFinderDAG.getCache(namespace);
        ResourceGenerationContext context = cache.makeContext(false);
        cache.reset(context);
        CONTEXTS.put(namespace, context);
        return context;
    }
}

