/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.initialization;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Supplier;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomPrimary;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomSecondary;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableTopSecondary;
import moonfather.workshop_for_handsome_adventurer.blocks.BookShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.DiscShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.DualTableBaseBlock;
import moonfather.workshop_for_handsome_adventurer.blocks.DualToolRack;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.SimpleTable;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.MissingMappingsHandler;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.SecondCreativeTab;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeLister;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.config.DynamicAssetCommonConfig;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.items.BlockItemEx;
import moonfather.workshop_for_handsome_adventurer.items.WorkstationPlacerItem;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.RegisterEvent;

public class DynamicContentRegistration {
    public static void handleRegistryEvent(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            if (DynamicAssetCommonConfig.masterLeverOn()) {
                DynamicContentRegistration.registerBlocksForThirdPartyWood(event);
            }
            MissingMappingsHandler.prepareMappings();
            MissingMappingsHandler.storeForNextTime();
        }
        if (event.getRegistryKey().equals(Registries.CREATIVE_MODE_TAB) && DynamicAssetCommonConfig.masterLeverOn() && SecondCreativeTab.usingSecondTab()) {
            event.register(Registries.CREATIVE_MODE_TAB, ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"tab2"), SecondCreativeTab::getTab);
        }
    }

    private static void registerSinglePrimaryBlockForThirdPartyWood(Block block, String id, List<Supplier<Block>> listForBlockEntities, List<Item> listForCreativeTab) {
        Item.Properties prop26 = new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id))).useBlockDescriptionPrefix();
        BlockItemEx item = new BlockItemEx(block, prop26);
        ResourceLocation fullId = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id);
        Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)fullId, (Object)block);
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)fullId, (Object)((Object)item));
        listForCreativeTab.add((Item)item);
        if (listForBlockEntities != null) {
            listForBlockEntities.add(() -> block);
        }
    }

    private static void registerSingleSupportBlockForThirdPartyWood(Block block, String id) {
        ResourceLocation fullId = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id);
        Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)fullId, (Object)block);
    }

    private static void registerBlocksForThirdPartyWood(RegisterEvent event) {
        try {
            boolean wasFrozen = ((MappedRegistry)BuiltInRegistries.BLOCK).frozen;
            if (wasFrozen) {
                ((MappedRegistry)BuiltInRegistries.BLOCK).unfreeze(false);
            }
            for (String wood : WoodTypeLister.getWoodIds()) {
                String id1 = "simple_table_" + wood;
                BlockBehaviour.Properties prop1 = SimpleTable.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id1)));
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new SimpleTable(prop1), id1, Registration.blocks_table1, SecondCreativeTab.items_table1);
                String id2 = "dual_table_bottom_left_" + wood;
                String id3 = "dual_table_bottom_right_" + wood;
                String id4 = "dual_table_top_left_" + wood;
                String id5 = "dual_table_top_right_" + wood;
                String desc = "item.%s.workstation_placer_%s".formatted("workshop_for_handsome_adventurer", wood);
                BlockBehaviour.Properties prop2 = DualTableBaseBlock.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id2))).overrideDescription(desc);
                BlockBehaviour.Properties prop3 = DualTableBaseBlock.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id3))).overrideDescription(desc);
                BlockBehaviour.Properties prop4 = DualTableBaseBlock.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id4))).overrideDescription(desc);
                BlockBehaviour.Properties prop5 = DualTableBaseBlock.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id5))).overrideDescription(desc);
                AdvancedTableBottomPrimary primary = new AdvancedTableBottomPrimary(prop2);
                DynamicContentRegistration.registerSingleSupportBlockForThirdPartyWood(primary, id2);
                DynamicContentRegistration.registerSingleSupportBlockForThirdPartyWood(new AdvancedTableBottomSecondary(prop3), id3);
                DynamicContentRegistration.registerSingleSupportBlockForThirdPartyWood(new AdvancedTableTopSecondary(prop4), id4);
                DynamicContentRegistration.registerSingleSupportBlockForThirdPartyWood(new AdvancedTableTopSecondary(prop5), id5);
                String id6 = "workstation_placer_" + wood;
                Item.Properties prop6 = new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id6)));
                WorkstationPlacerItem placer = new WorkstationPlacerItem(wood, prop6);
                Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id6), (Object)((Object)placer));
                Registration.blocks_table2.add(() -> primary);
                SecondCreativeTab.items_table2.add(placer);
                String id7 = "tool_rack_single_" + wood;
                String id8 = "tool_rack_framed_" + wood;
                String id9 = "tool_rack_pframed_" + wood;
                String idA = "tool_rack_double_" + wood;
                BlockBehaviour.Properties prop7 = ToolRack.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id7)));
                BlockBehaviour.Properties prop8 = ToolRack.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id8)));
                BlockBehaviour.Properties prop9 = ToolRack.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id9)));
                BlockBehaviour.Properties propA = ToolRack.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)idA)));
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(ToolRack.create(2, "single", prop7), id7, Registration.blocks_rack, SecondCreativeTab.items_rack1);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(DualToolRack.create(6, "framed", prop8), id8, Registration.blocks_rack, SecondCreativeTab.items_rack2);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(DualToolRack.create(6, "pframed", prop9), id9, Registration.blocks_rack, SecondCreativeTab.items_rack3);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(DualToolRack.create(6, "double", propA), idA, Registration.blocks_rack, SecondCreativeTab.items_rack4);
                String id11 = "potion_shelf_" + wood;
                BlockBehaviour.Properties prop11 = PotionShelf.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id11)));
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new PotionShelf(prop11), id11, Registration.blocks_pshelf, SecondCreativeTab.items_pshelf);
                String id91 = "disc_shelf_" + wood;
                BlockBehaviour.Properties prop91 = DiscShelf.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id91)));
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new DiscShelf(prop91), id91, Registration.blocks_dshelf, SecondCreativeTab.items_dshelf);
                String id12 = "book_shelf_double_" + wood;
                String id13 = "book_shelf_open_double_" + wood;
                String id14 = "book_shelf_minimal_" + wood;
                String id15 = "book_shelf_open_minimal_" + wood;
                String id16 = "book_shelf_with_lanterns_" + wood;
                BlockBehaviour.Properties prop12 = BookShelf.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id12)));
                BlockBehaviour.Properties prop13 = BookShelf.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id13)));
                BlockBehaviour.Properties prop14 = BookShelf.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id14)));
                BlockBehaviour.Properties prop15 = BookShelf.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id15)));
                BlockBehaviour.Properties prop16 = BookShelf.getDefaultProperties().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id16)));
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new BookShelf.Dual("double", prop12), id12, Registration.blocks_bshelf, SecondCreativeTab.items_bshelf1);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new BookShelf.Dual("open_double", prop13), id13, Registration.blocks_bshelf, SecondCreativeTab.items_bshelf2);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new BookShelf.TopSimple("minimal", prop14), id14, Registration.blocks_bshelf, SecondCreativeTab.items_bshelf3);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new BookShelf.TopSimple("open_minimal", prop15), id15, Registration.blocks_bshelf, SecondCreativeTab.items_bshelf4);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new BookShelf.TopWithLanterns("with_lanterns", prop16), id16, Registration.blocks_bshelf, SecondCreativeTab.items_bshelf5);
            }
            if (wasFrozen) {
                BuiltInRegistries.BLOCK.freeze();
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().error("WFHA error 141: " + e.getMessage());
        }
    }
}

