/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.integration;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import moonfather.workshop_for_handsome_adventurer.block_entities.PotionShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.DiscShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import moonfather.workshop_for_handsome_adventurer.integration.JadePotionDataProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.TextElement;

public class JadePotionTooltipProvider
implements IBlockComponentProvider {
    private static final JadePotionTooltipProvider instance = new JadePotionTooltipProvider();
    private final ResourceLocation pluginId = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"jade_plugin1");

    public static JadePotionTooltipProvider getInstance() {
        return instance;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        int slot;
        PotionShelfBlockEntity shelf;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof PotionShelfBlockEntity && !shelf.GetItem(slot = (shelf = (PotionShelfBlockEntity)blockEntity).getNumberOfItems() != 9 ? PotionShelf.getPotionShelfSlot((BlockHitResult)accessor.getHitResult()) : DiscShelf.getDiscShelfSlot((BlockHitResult)accessor.getHitResult())).isEmpty()) {
            Optional serverData = JadePotionDataProvider.getInstance().decodeFromData((Accessor)accessor);
            int count = serverData.isPresent() ? ((Integer)((List)serverData.get()).get(slot)).intValue() : shelf.GetRemainingItems(slot).intValue();
            ArrayList<TextElement> list = new ArrayList<TextElement>(2);
            list.add(JadeUI.text((Component)Component.literal((String)(" " + count + "x  "))));
            list.add(JadeUI.text((Component)shelf.GetItem(slot).getHoverName()));
            tooltip.add(list);
            JukeboxPlayable songContainer = (JukeboxPlayable)shelf.GetItem(slot).get(DataComponents.JUKEBOX_PLAYABLE);
            if (songContainer != null) {
                ArrayList<TextElement> list2 = new ArrayList<TextElement>(2);
                list2.add(JadeUI.text((Component)Component.literal((String)" ")));
                EitherHolder song = songContainer.song();
                song.unwrap((HolderLookup.Provider)accessor.getLevel().registryAccess()).ifPresent(holder -> list2.add(JadeUI.text((Component)((JukeboxSong)holder.value()).description())));
                tooltip.add(list2);
            }
        }
    }

    public ResourceLocation getUid() {
        return this.pluginId;
    }
}

