/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.integration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.component.ItemComponent;
import moonfather.workshop_for_handsome_adventurer.ClientConfig;
import moonfather.workshop_for_handsome_adventurer.CommonConfig;
import moonfather.workshop_for_handsome_adventurer.block_entities.BookShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.PotionShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.BookShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.DiscShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.DualTableBaseBlock;
import moonfather.workshop_for_handsome_adventurer.blocks.DualToolRack;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.integration.WailaBaseProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class WthitPlugin
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.addComponent((IBlockComponentProvider)new WorkstationProvider(), TooltipPosition.HEAD, DualTableBaseBlock.class);
        registrar.addIcon((IBlockComponentProvider)new WorkstationProvider(), DualTableBaseBlock.class);
        registrar.addComponent((IBlockComponentProvider)new PotionShelfProvider(), TooltipPosition.TAIL, PotionShelfBlockEntity.class);
        registrar.addBlockData((IDataProvider)new PotionShelfDataProvider(), PotionShelf.class);
        registrar.addComponent((IBlockComponentProvider)new BookShelfProvider(), TooltipPosition.TAIL, BookShelfBlockEntity.class);
        registrar.addComponent((IBlockComponentProvider)new ToolRackProvider1(), TooltipPosition.TAIL, ToolRackBlockEntity.class);
        registrar.addComponent((IBlockComponentProvider)new ToolRackProvider2(), TooltipPosition.TAIL, DualToolRack.class);
    }

    private static class WorkstationProvider
    implements IBlockComponentProvider {
        private static final Map<Block, ItemComponent> map = new HashMap<Block, ItemComponent>();
        private static final ResourceLocation topLine = ResourceLocation.fromNamespaceAndPath((String)"waila", (String)"object_name");

        private WorkstationProvider() {
        }

        @Nullable
        public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
            return this.getPlacerItem(accessor);
        }

        public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            tooltip.setLine(topLine, this.getPlacerItem((IBlockAccessor)accessor).stack.getHoverName());
        }

        private ItemComponent getPlacerItem(IBlockAccessor accessor) {
            Block block = accessor.getBlock();
            if (map.containsKey(block)) {
                return map.get(block);
            }
            ItemStack placer = block.getCloneItemStack((LevelReader)accessor.getWorld(), accessor.getPosition(), accessor.getBlockState(), false, accessor.getPlayer());
            ItemComponent result = new ItemComponent(placer);
            map.put(block, result);
            return result;
        }
    }

    private static class PotionShelfProvider
    implements IBlockComponentProvider {
        private static final String messageP = "message.workshop_for_handsome_adventurer.shelf_probe_tooltip";
        private static final String messageD = "message.workshop_for_handsome_adventurer.shelf_probe_tooltip2";

        private PotionShelfProvider() {
        }

        public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof PotionShelfBlockEntity) {
                int slot;
                String message;
                PotionShelfBlockEntity shelf = (PotionShelfBlockEntity)blockEntity;
                if (shelf.getNumberOfItems() == 9) {
                    message = messageD;
                    slot = DiscShelf.getDiscShelfSlot((HitResult)accessor.getBlockHitResult(), accessor.getPosition(), accessor.getSide());
                } else {
                    message = messageP;
                    slot = PotionShelf.getPotionShelfSlot((HitResult)accessor.getBlockHitResult(), accessor.getPosition(), accessor.getSide());
                }
                if (!shelf.GetItem(slot).isEmpty()) {
                    int room;
                    int count;
                    if (accessor.getData().raw().contains("Bottles" + slot)) {
                        count = accessor.getData().raw().getIntOr("Bottles" + slot, 0);
                        room = accessor.getData().raw().getIntOr("Space" + slot, (Integer)CommonConfig.SlotRoomMaximum.get() - count);
                    } else {
                        count = shelf.GetRemainingItems(slot);
                        room = shelf.GetRemainingRoom(slot);
                    }
                    ItemStack bottle = shelf.GetItem(slot);
                    tooltip.addLine().with((ITooltipComponent)new ItemComponent(bottle)).with(bottle.getHoverName());
                    JukeboxPlayable songContainer = (JukeboxPlayable)bottle.get(DataComponents.JUKEBOX_PLAYABLE);
                    if (songContainer != null) {
                        EitherHolder song = songContainer.song();
                        song.unwrap((HolderLookup.Provider)accessor.getPlayer().registryAccess()).ifPresent(holder -> tooltip.addLine().with(((JukeboxSong)holder.value()).description()));
                    }
                    if (count + room > 1) {
                        tooltip.addLine((Component)Component.translatable((String)message, (Object[])new Object[]{count, count + room}));
                    }
                } else {
                    int roomTotal = shelf.GetRemainingRoom(slot);
                    if (roomTotal > 1) {
                        tooltip.addLine((Component)Component.translatable((String)message, (Object[])new Object[]{0, roomTotal}));
                    }
                }
            }
        }
    }

    private static class PotionShelfDataProvider
    implements IDataProvider<PotionShelfBlockEntity> {
        private PotionShelfDataProvider() {
        }

        public void appendData(IDataWriter writer, IServerAccessor<PotionShelfBlockEntity> serverAccessor, IPluginConfig config) {
            int max = ((PotionShelfBlockEntity)((Object)serverAccessor.getTarget())).getNumberOfItemsInOneRow() * 2;
            for (int i = 0; i < max; ++i) {
                int bottles = ((PotionShelfBlockEntity)((Object)serverAccessor.getTarget())).GetRemainingItems(i);
                writer.raw().putInt("Bottles" + i, bottles);
                int space = ((PotionShelfBlockEntity)((Object)serverAccessor.getTarget())).GetRemainingRoom(i);
                writer.raw().putInt("Space" + i, space);
            }
        }
    }

    private static class BookShelfProvider
    extends WailaBaseProvider
    implements IBlockComponentProvider {
        private BookShelfProvider() {
        }

        public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof BookShelfBlockEntity) {
                BookShelfBlockEntity shelf = (BookShelfBlockEntity)blockEntity;
                int slot = BookShelf.getBookShelfSlot((BookShelf)accessor.getBlock(), accessor.getBlockHitResult());
                if (slot >= 0 && !shelf.GetItem(slot).isEmpty()) {
                    List<Component> enchantments;
                    tooltip.addLine().with((ITooltipComponent)new ItemComponent(shelf.GetItem(slot))).with(shelf.GetItem(slot).getHoverName());
                    if (ClientConfig.detailedWailaInfoForEnchantedBooks && (enchantments = this.getEnchantmentParts(shelf.GetItem(slot))) != null) {
                        for (int i = 0; i < enchantments.size(); ++i) {
                            tooltip.addLine().with(enchantments.get(i));
                        }
                    }
                }
            }
        }
    }

    private static class ToolRackProvider1
    extends WailaBaseProvider
    implements IBlockComponentProvider {
        private ToolRackProvider1() {
        }

        public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            List<Component> enchantments;
            ItemStack tool = ItemStack.EMPTY;
            if (accessor.getBlockEntity() instanceof PotionShelfBlockEntity || accessor.getBlockEntity() instanceof BookShelfBlockEntity) {
                return;
            }
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof ToolRackBlockEntity) {
                ToolRackBlockEntity rack = (ToolRackBlockEntity)blockEntity;
                int slot = ToolRack.getToolRackSlot((ToolRack)accessor.getBlock(), accessor.getBlockHitResult());
                tool = rack.GetItem(slot);
            }
            if (tool.isEmpty()) {
                return;
            }
            tooltip.addLine().with((ITooltipComponent)new ItemComponent(tool)).with(tool.getHoverName());
            if (ClientConfig.detailedWailaInfoForEnchantedTools && (enchantments = this.getEnchantmentParts(tool)) != null) {
                for (int i = 0; i < enchantments.size(); ++i) {
                    tooltip.addLine().with(enchantments.get(i));
                }
            }
        }
    }

    private static class ToolRackProvider2
    extends WailaBaseProvider
    implements IBlockComponentProvider {
        private ToolRackProvider2() {
        }

        public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            List<Component> enchantments;
            ItemStack tool = ItemStack.EMPTY;
            Block block = accessor.getBlock();
            if (block instanceof DualToolRack) {
                DualToolRack block2 = (DualToolRack)block;
                if (accessor.getBlockEntity() == null) {
                    BlockPos above = accessor.getPosition().above();
                    ToolRackBlockEntity rack = (ToolRackBlockEntity)accessor.getWorld().getBlockEntity(above);
                    int slot = ToolRack.getToolRackSlot(block2, accessor.getBlockHitResult().withPosition(above));
                    tool = rack.GetItem(slot);
                }
            }
            if (tool.isEmpty()) {
                return;
            }
            tooltip.addLine().with((ITooltipComponent)new ItemComponent(tool)).with(tool.getHoverName());
            if (ClientConfig.detailedWailaInfoForEnchantedTools && (enchantments = this.getEnchantmentParts(tool)) != null) {
                for (int i = 0; i < enchantments.size(); ++i) {
                    tooltip.addLine().with(enchantments.get(i));
                }
            }
        }
    }
}

