/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items;

import java.util.function.Consumer;
import moonfather.workshop_for_handsome_adventurer.blocks.DualToolRack;
import moonfather.workshop_for_handsome_adventurer.blocks.IBlockWithCleverHoverText;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.FuelValues;
import org.jetbrains.annotations.Nullable;

public class BlockItemEx
extends BlockItem {
    private final int burnTime;

    public BlockItemEx(Block block, Item.Properties properties) {
        super(block, properties);
        this.burnTime = block instanceof ToolRack ? (!(block instanceof DualToolRack) ? 150 : 900) : 300;
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType, FuelValues fuelValues) {
        return this.burnTime;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        Block block = this.getBlock();
        if (block instanceof IBlockWithCleverHoverText) {
            IBlockWithCleverHoverText ourBlock = (IBlockWithCleverHoverText)block;
            for (Component c : ourBlock.getTooltipLines()) {
                tooltipAdder.accept(c);
            }
        }
    }
}

