/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public class BasicBlockEntity
extends BlockEntity {
    protected static final Logger LOGGER = LogUtils.getLogger();

    public BasicBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.saveInternal(output);
    }

    protected ValueOutput saveInternal(ValueOutput output) {
        return output;
    }

    public void handleUpdateTag(ValueInput input) {
        this.loadWithComponents(input);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        try (ProblemReporter.ScopedCollector pr = new ProblemReporter.ScopedCollector(LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)pr.forChild(this.problemPath()), (HolderLookup.Provider)registries);
            this.saveInternal((ValueOutput)output);
            CompoundTag compoundTag = output.buildResult();
            return compoundTag;
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void sendUpdated() {
        BasicBlockEntity.sendUpdated(this.getLevel(), this.getBlockPos());
    }

    public static void sendUpdated(@Nullable Level level, BlockPos pos) {
        ChunkSource chunkSource;
        if (level != null && (chunkSource = level.getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache scc = (ServerChunkCache)chunkSource;
            scc.blockChanged(pos);
        }
    }
}

