/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities;

import java.util.Optional;
import moonfather.workshop_for_handsome_adventurer.items.task_list.RegistrationForTaskList;
import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.BasicBlockEntity;
import moonfather.workshop_for_handsome_adventurer.items.task_list.blocks.TaskListPanel;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.TaskListItem;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListComponent;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListMessaging;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.screens.TaskListClientInvoker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class TaskListBlockEntity
extends BasicBlockEntity
implements Nameable {
    private int currentPage;
    private TaskListComponent data;
    private String title = "asdfg";
    private Component titleAsComponent = null;
    private boolean isFireResistant = false;
    private ItemStack item;
    private boolean isModified = false;
    private static final TaskListMessaging.TaskPageDTO EMPTY = new TaskListMessaging.TaskPageDTO(1, null);
    private String footer = null;

    public TaskListBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public TaskListBlockEntity(BlockPos pos, BlockState blockState) {
        super(RegistrationForTaskList.TASK_LIST_PANEL_BE.get(), pos, blockState);
    }

    public void setItem(ItemStack taskList) {
        this.item = taskList;
        this.data = (TaskListComponent)taskList.get(TaskListItem.Utility.ourComponent());
        if (this.data == null) {
            this.data = new TaskListComponent(1, 1, null);
        }
        this.currentPage = this.data.getLastPageNumber();
        this.title = TaskListItem.Utility.getTitle(this.item);
        this.isFireResistant = TaskListItem.Utility.isFireImmune(this.item);
        this.titleAsComponent = null;
        this.setChanged();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int newPage) {
        this.currentPage = newPage;
    }

    public TaskListMessaging.TaskPageDTO getPageForDisplay() {
        if (this.data == null) {
            return EMPTY;
        }
        return this.data.getAllPages().get(this.currentPage - 1);
    }

    public int getPageCount() {
        if (this.data == null) {
            return 7;
        }
        return this.data.getPageCount();
    }

    public boolean isFireResistant() {
        return this.isFireResistant;
    }

    public String getTitle() {
        return this.title;
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.isModified = input.getBooleanOr("isModified", false);
        Optional storedItem = input.read("original", ItemStack.CODEC);
        if (storedItem.isPresent()) {
            this.setItem((ItemStack)storedItem.get());
            this.setCurrentPage(input.getIntOr("currentPage", 1));
            return;
        }
        this.setItem(TaskListItem.Utility.createInstance());
        this.setCurrentPage(1);
        Optional checkmarks = input.getIntArray("checkmarks");
        if (checkmarks.isPresent()) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (this.data.getAllPages().get(i).items().get(j).status().codePointAt(0) == ((int[])checkmarks.get())[i * 6 + j]) continue;
                    this.data.getAllPages().get(i).items().set(j, new TaskListMessaging.TaskItemDTO(Character.toString(((int[])checkmarks.get())[i * 6 + j]), this.data.getAllPages().get(i).items().get(j).line1(), this.data.getAllPages().get(i).items().get(j).line2()));
                }
            }
        }
    }

    @Override
    protected ValueOutput saveInternal(ValueOutput output) {
        output.putBoolean("isModified", this.isModified);
        output.putInt("currentPage", this.getCurrentPage());
        output.store("original", ItemStack.CODEC, (Object)this.item);
        int[] checkmarks = new int[24];
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 6; ++j) {
                checkmarks[k++] = this.data.getAllPages().get(i).items().get(j).status().codePointAt(0);
            }
        }
        output.putIntArray("checkmarks", checkmarks);
        return output;
    }

    public String getFooter() {
        if (this.data == null) {
            return "1/8";
        }
        if (this.footer == null) {
            this.footer = this.getCurrentPage() + "/" + this.getPageCount();
        }
        return this.footer;
    }

    public void onArrowPrev() {
        if (this.getCurrentPage() > 1) {
            this.setCurrentPage(this.getCurrentPage() - 1);
            this.setChanged();
        }
    }

    public void onArrowNext() {
        if (this.getCurrentPage() < this.getPageCount()) {
            this.setCurrentPage(this.getCurrentPage() + 1);
            this.setChanged();
        }
    }

    public void onClientArrowNext() {
        if (this.getCurrentPage() < this.getPageCount()) {
            this.onArrowNext();
            this.footer = null;
            TaskListMessaging.sendBlockClickPageRightToServer(this.getBlockPos());
        }
    }

    public void onClientArrowPrev() {
        if (this.getCurrentPage() > 1) {
            this.onArrowPrev();
            this.footer = null;
            TaskListMessaging.sendBlockClickPageLeftToServer(this.getBlockPos());
        }
    }

    public void checkmarkClickedOnBlock(int index) {
        this.updateCheckmark(index, this.getCurrentPage());
        TaskListMessaging.sendBlockClickCheckmarkServer(this.getBlockPos(), index, this.getCurrentPage());
    }

    public void updateCheckmark(int index, int pageNumber) {
        if (this.getCurrentPage() != pageNumber) {
            this.setCurrentPage(pageNumber);
        }
        TaskListMessaging.TaskItemDTO old = this.data.getAllPages().get(pageNumber - 1).items().get(index);
        String newValue = switch (old.status()) {
            case "e" -> "y";
            case "y" -> "n";
            case "n" -> "q";
            default -> "e";
        };
        this.data.getAllPages().get(pageNumber - 1).items().set(index, new TaskListMessaging.TaskItemDTO(newValue, old.line1(), old.line2()));
        this.setChanged();
    }

    public void invokeGUI() {
        TaskListMessaging.TaskListExtraDTO extra = new TaskListMessaging.TaskListExtraDTO(this.getBlockPos(), this.data.getLastPageNumber(), this.getTitle());
        TaskListClientInvoker.invokeScreen(this.data.getAllPages(), this.data.getPageCount(), extra, this.isFireResistant);
    }

    @Nullable
    public Component getCustomName() {
        if (this.titleAsComponent == null) {
            this.titleAsComponent = Component.literal((String)this.title);
        }
        return this.titleAsComponent;
    }

    public Component getName() {
        if (this.titleAsComponent == null) {
            this.titleAsComponent = Component.literal((String)this.title);
        }
        return this.titleAsComponent;
    }

    public ItemStack getItem() {
        return this.item;
    }

    private ItemStack getItemForDrop() {
        ItemStack result = this.item.copy();
        this.data.setLastPage(this.currentPage);
        result.set(TaskListItem.Utility.ourComponent(), (Object)this.data);
        TaskListItem.Utility.setTitle(result, this.title);
        return result;
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Block.popResourceFromFace((Level)this.level, (BlockPos)pos, (Direction)((Direction)state.getValue(TaskListPanel.FACING)), (ItemStack)this.getItemForDrop());
    }
}

