/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import moonfather.workshop_for_handsome_adventurer.ClientConfig;
import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.TaskListBlockEntity;
import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.renderers.SpecialFirstEverRenderer;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListMessaging;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@ParametersAreNonnullByDefault
public class TaskListPanelTESR
implements BlockEntityRenderer<TaskListBlockEntity> {
    private static final Quaternionf XPlus180 = new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, 180.0f);
    private static final Quaternionf YPlus180 = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 180.0f);
    private static final Quaternionf YPlus090 = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 90.0f);
    private static final Quaternionf YPlus270 = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 270.0f);
    private static final Quaternionf ZPlus180 = new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 180.0f);
    private static final int textColorMain = -12303275;
    private static final int textColorGrayed = -8026747;
    private static final int textColorDividers = -6645099;

    public TaskListPanelTESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(TaskListBlockEntity tile, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, int combinedOverlay, Vec3 camera) {
        if (!ClientConfig.taskListItemsAreDrawnOnWall) {
            return;
        }
        Direction direction = (Direction)tile.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        poseStack.pushPose();
        if (direction.equals((Object)Direction.NORTH)) {
            poseStack.mulPose((Quaternionfc)ZPlus180);
            poseStack.translate(-1.0f, -1.0f, 0.925f);
        }
        if (direction.equals((Object)Direction.EAST)) {
            poseStack.mulPose((Quaternionfc)XPlus180);
            poseStack.mulPose((Quaternionfc)YPlus270);
            poseStack.translate(-1.0f, -1.0f, -0.068750024f);
        }
        if (direction.equals((Object)Direction.SOUTH)) {
            poseStack.mulPose((Quaternionfc)ZPlus180);
            poseStack.mulPose((Quaternionfc)YPlus180);
            poseStack.translate(0.0f, -1.0f, -0.07499999f);
        }
        if (direction.equals((Object)Direction.WEST)) {
            poseStack.mulPose((Quaternionfc)XPlus180);
            poseStack.mulPose((Quaternionfc)YPlus090);
            poseStack.translate(0.0f, -1.0f, 0.93125f);
        }
        poseStack.scale(0.0035f, 0.0045f, 0.005f);
        int normalTextLight = 0x410041;
        int finishedTextLight = 0x410041;
        combinedLight = this.reduceLightBasedOnDirection(combinedLight, direction);
        normalTextLight = this.reduceLightBasedOnDirection(normalTextLight, direction);
        finishedTextLight = this.reduceLightBasedOnDirection(finishedTextLight, direction);
        float hpixel = 17.0f;
        float vpixel = 13.0f;
        float itemTextStart = 4.5f;
        TaskListMessaging.TaskPageDTO page = tile.getPageForDisplay();
        for (int i = 0; i < 6; ++i) {
            int color = -12303275;
            int light = normalTextLight;
            if (ClientConfig.taskListColoringForFinishedItems && (page.items().get(i).status().equals("y") || page.items().get(i).status().equals("n"))) {
                color = -8026747;
                light = finishedTextLight;
            }
            Minecraft.getInstance().font.drawInBatch(page.items().get(i).line1(), 76.5f, (float)(3 + 2 * i) * 13.0f, color, false, poseStack.last().pose(), multiBufferSource, Font.DisplayMode.NORMAL, 0, light);
            Minecraft.getInstance().font.drawInBatch(page.items().get(i).line2(), 76.5f, (float)(3 + 2 * i + 1) * 13.0f, color, false, poseStack.last().pose(), multiBufferSource, Font.DisplayMode.NORMAL, 0, light);
        }
        Minecraft.getInstance().font.drawInBatch("<<", 51.0f, 195.0f, -12303275, false, poseStack.last().pose(), multiBufferSource, Font.DisplayMode.NORMAL, 0, normalTextLight);
        Minecraft.getInstance().font.drawInBatch(tile.getFooter(), 136.0f, 195.0f, -12303275, false, poseStack.last().pose(), multiBufferSource, Font.DisplayMode.NORMAL, 0, normalTextLight);
        Minecraft.getInstance().font.drawInBatch(">>", 229.5f, 195.0f, -12303275, false, poseStack.last().pose(), multiBufferSource, Font.DisplayMode.NORMAL, 0, normalTextLight);
        int lightColor = tile.getLevel() != null ? LevelRenderer.getLightColor((BlockAndTintGetter)tile.getLevel(), (BlockPos)tile.getBlockPos()) : -1;
        for (int i = 0; i < 6; ++i) {
            SpecialFirstEverRenderer.render(page.items().get(i).status(), 3.0f, (float)(3 + 2 * i) + 0.5f, poseStack, multiBufferSource, combinedLight, combinedOverlay, lightColor);
        }
        float scaleX = 32.0f;
        poseStack.scale(scaleX, 1.0f, 0.25f);
        float intendedStart = 3.5f;
        float start = 0.0f * intendedStart + 0.115f;
        for (int i = 0; i < 5; ++i) {
            Minecraft.getInstance().font.drawInBatch("_", start * 17.0f, ((float)(4 + 2 * i) + 0.2f) * 13.0f, -6645099, false, poseStack.last().pose(), multiBufferSource, Font.DisplayMode.NORMAL, 0, 0x220022);
        }
        poseStack.popPose();
    }

    private int reduceLightBasedOnDirection(int originalLight, Direction direction) {
        int mul = direction.equals((Object)Direction.NORTH) || direction.equals((Object)Direction.SOUTH) ? 80 : 65;
        int byteValue = originalLight >> 16 & 0xFF;
        int result = byteValue = byteValue * mul / 100;
        byteValue = originalLight >> 8 & 0xFF;
        byteValue = byteValue * mul / 100;
        result = (result << 8) + byteValue;
        byteValue = originalLight & 0xFF;
        byteValue = byteValue * mul / 100;
        result = (result << 8) + byteValue;
        return result |= originalLight & 0xFF000000;
    }
}

