/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.blocks;

import java.util.HashMap;
import java.util.Map;
import moonfather.workshop_for_handsome_adventurer.ClientConfig;
import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.TaskListBlockEntity;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.TaskListItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskListPanel
extends Block
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty EMPTY = BooleanProperty.create((String)"empty");
    private static final VoxelShape SHAPE_PLANK1S = Block.box((double)1.5, (double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)1.0);
    private static final VoxelShape SHAPE_PLANK1W = Block.box((double)15.0, (double)0.0, (double)1.5, (double)16.0, (double)16.0, (double)14.5);
    private static final VoxelShape SHAPE_PLANK1N = Block.box((double)1.5, (double)0.0, (double)15.0, (double)14.5, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_PLANK1E = Block.box((double)0.0, (double)0.0, (double)1.5, (double)1.0, (double)16.0, (double)14.5);
    protected final Map<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>(4);

    public TaskListPanel(String id) {
        super(BlockBehaviour.Properties.of().strength(0.3f, 0.6f).sound(SoundType.WOOD).mapColor(MapColor.COLOR_BROWN).pushReaction(PushReaction.DESTROY).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)id))));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)EMPTY, (Comparable)Boolean.valueOf(true)));
        this.PrepareListOfShapes();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{EMPTY});
    }

    protected void PrepareListOfShapes() {
        this.shapes.put(Direction.NORTH, SHAPE_PLANK1N);
        this.shapes.put(Direction.EAST, SHAPE_PLANK1E);
        this.shapes.put(Direction.SOUTH, SHAPE_PLANK1S);
        this.shapes.put(Direction.WEST, SHAPE_PLANK1W);
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.shapes.get(state.getValue(FACING));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace() == Direction.DOWN || context.getClickedFace() == Direction.UP) {
            return null;
        }
        BlockState result = (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace());
        if (this.canSurvive(result, (LevelReader)context.getLevel(), context.getClickedPos())) {
            return result;
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos target = pos.relative(((Direction)state.getValue(FACING)).getOpposite());
        return world.getBlockState(target).isFaceSturdy((BlockGetter)world, target, (Direction)state.getValue(FACING));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TaskListBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return null;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, orientation, movedByPiston);
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, false);
        }
    }

    public PushReaction getPistonPushReaction(BlockState p_60584_) {
        return PushReaction.DESTROY;
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        return TaskListItem.Utility.createInstance();
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TaskListBlockEntity) {
            TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity;
            return !tile.isFireResistant();
        }
        return super.isFlammable(state, level, pos, direction);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        TaskListBlockEntity tile;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TaskListBlockEntity && (tile = (TaskListBlockEntity)blockEntity).isFireResistant()) {
            return 0;
        }
        return 20;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!ClientConfig.taskListItemsAreDrawnOnWall) {
            if (level.isClientSide) {
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (blockEntity2 instanceof TaskListBlockEntity) {
                    TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity2;
                    tile.invokeGUI();
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            player.awardStat(Stats.ITEM_USED.get((Object)TaskListItem.Utility.ourItem()));
            return InteractionResult.CONSUME;
        }
        if (!level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        double y = hitResult.getLocation().y - (double)hitResult.getBlockPos().getY();
        double x = 0.0;
        if (hitResult.getDirection().getAxis().equals((Object)Direction.Axis.X)) {
            x = hitResult.getLocation().z() - (double)hitResult.getBlockPos().getZ();
            if (hitResult.getDirection().equals((Object)Direction.EAST)) {
                x = 1.0 - x;
            }
        } else {
            x = hitResult.getLocation().x() - (double)hitResult.getBlockPos().getX();
            if (hitResult.getDirection().equals((Object)Direction.NORTH)) {
                x = 1.0 - x;
            }
        }
        if (y <= 0.15 && x <= 0.25 && (blockEntity = level.getBlockEntity(pos)) instanceof TaskListBlockEntity) {
            TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity;
            tile.onClientArrowPrev();
            return InteractionResult.SUCCESS;
        }
        if (y <= 0.15 && x >= 0.75 && (blockEntity = level.getBlockEntity(pos)) instanceof TaskListBlockEntity) {
            TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity;
            tile.onClientArrowNext();
            return InteractionResult.SUCCESS;
        }
        double yFromTop = 1.0 - y;
        float vOffset = -0.04321f;
        for (int i = 0; i < 6; ++i) {
            if (!(x >= 0.125) || !(x <= 0.25) || !(yFromTop >= (double)((float)(3 + 2 * i) / 16.0f + vOffset)) || !(yFromTop <= (double)((float)(3 + 2 * i + 2) / 16.0f + vOffset))) continue;
            BlockEntity blockEntity3 = level.getBlockEntity(pos);
            if (!(blockEntity3 instanceof TaskListBlockEntity)) break;
            TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity3;
            tile.checkmarkClickedOnBlock(i);
            break;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }
}

