/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.other;

import java.util.ArrayList;
import java.util.List;
import moonfather.workshop_for_handsome_adventurer.block_entities.BaseContainerBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.BookShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.DiscShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.gui.GuiLayer;
import org.jetbrains.annotations.NotNull;

public class InWorldTooltip
implements GuiLayer {
    private static final InWorldTooltip instance = new InWorldTooltip();
    private int lastHash = -1;
    private List<ClientTooltipComponent> lastList = null;

    public static InWorldTooltip getInstance() {
        return instance;
    }

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        BlockHitResult hitResult;
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().level == null || Minecraft.getInstance().screen != null) {
            return;
        }
        HitResult hitResult2 = Minecraft.getInstance().hitResult;
        if (hitResult2 instanceof BlockHitResult && (hitResult = (BlockHitResult)hitResult2).getType().equals((Object)HitResult.Type.BLOCK)) {
            BaseContainerBlockEntity blockEntity;
            BlockPos pos;
            Block block;
            BlockState blockState = Minecraft.getInstance().level.getBlockState(hitResult.getBlockPos());
            int slot = -5;
            boolean above = false;
            if (blockState.getBlock() instanceof DiscShelf) {
                if (!((Direction)blockState.getValue((Property)DiscShelf.FACING)).equals((Object)hitResult.getDirection().getOpposite())) {
                    return;
                }
                slot = DiscShelf.getDiscShelfSlot(hitResult);
            } else if (blockState.getBlock() instanceof PotionShelf) {
                if (!((Direction)blockState.getValue((Property)PotionShelf.FACING)).equals((Object)hitResult.getDirection().getOpposite())) {
                    return;
                }
                slot = PotionShelf.getPotionShelfSlot(hitResult);
            } else {
                block = blockState.getBlock();
                if (block instanceof BookShelf) {
                    BookShelf bookShelf = (BookShelf)block;
                    if (!((Direction)blockState.getValue((Property)BookShelf.FACING)).equals((Object)hitResult.getDirection().getOpposite())) {
                        return;
                    }
                    slot = BookShelf.getBookShelfSlot(bookShelf, hitResult);
                } else {
                    block = blockState.getBlock();
                    if (block instanceof ToolRack) {
                        ToolRack toolRack = (ToolRack)block;
                        if (!((Direction)blockState.getValue((Property)BookShelf.FACING)).equals((Object)hitResult.getDirection().getOpposite())) {
                            return;
                        }
                        if (Minecraft.getInstance().level.getBlockEntity(hitResult.getBlockPos()) != null) {
                            slot = ToolRack.getToolRackSlot(toolRack, hitResult);
                        } else {
                            above = true;
                            slot = ToolRack.getToolRackSlot(toolRack, new BlockHitResult(hitResult.getLocation(), hitResult.getDirection(), hitResult.getBlockPos().above(), false));
                        }
                    }
                }
            }
            if (slot >= 0 && (block = Minecraft.getInstance().level.getBlockEntity(pos = above ? hitResult.getBlockPos().above() : hitResult.getBlockPos())) instanceof BaseContainerBlockEntity && !(blockEntity = (BaseContainerBlockEntity)block).GetItem(slot).isEmpty()) {
                int itemHash = blockEntity.GetItem(slot).hashCode();
                if (this.lastHash != itemHash) {
                    this.lastHash = itemHash;
                    this.lastList = new ArrayList<ClientTooltipComponent>(8);
                    List tooltip = blockEntity.GetItem(slot).getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().level), (Player)Minecraft.getInstance().player, (TooltipFlag)TooltipFlag.Default.NORMAL);
                    for (Component c : tooltip) {
                        this.lastList.add(ClientTooltipComponent.create((FormattedCharSequence)c.getVisualOrderText()));
                    }
                }
                guiGraphics.renderTooltip(Minecraft.getInstance().font, this.lastList, Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - 30, Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2 + 20, DefaultTooltipPositioner.INSTANCE, null);
            }
        }
    }
}

