/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.screens;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import moonfather.workshop_for_handsome_adventurer.CommonConfig;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.screens.InventoryAccessComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleTableCraftingScreen
extends AbstractContainerScreen<SimpleTableMenu> {
    private static final ResourceLocation[] CRAFTING_TABLE_LOCATION = new ResourceLocation[3];
    private List<Component> tooltipCustomizationsFull = null;
    private List<Component> tooltipCustomizationsBrief = null;
    private final InventoryAccessComponent inventoryComponent = new InventoryAccessComponent();
    protected int renderLeftPos;
    private TextureAtlasSprite excessSlotSprite = null;
    private static final ResourceLocation EXCESS_SLOT_BG = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"gui/x_slot");
    private final Component tooltipCustomizationsTitle = Component.translatable((String)"message.workshop_for_handsome_adventurer.extension_slotT").withStyle(Style.EMPTY.withColor(0xAA77DD));
    private final Component tooltipCustomizationsShift = Component.translatable((String)"message.workshop_for_handsome_adventurer.extension_slotS").withStyle(ChatFormatting.DARK_GRAY);
    protected ResourceLocation backgroundImageLocation = null;

    public SimpleTableCraftingScreen(SimpleTableMenu p_98448_, Inventory p_98449_, Component p_98450_) {
        super((AbstractContainerMenu)p_98448_, p_98449_, p_98450_);
    }

    protected void init() {
        super.init();
        this.inventoryComponent.init(this, this.width < 400);
        this.setPositionsX();
        this.addWidget(this.inventoryComponent);
    }

    public void setPositionsX() {
        int leftPanel = this.inventoryComponent.getWidth();
        this.leftPos = (this.width - this.imageWidth - leftPanel) / 2;
        this.renderLeftPos = this.leftPos + leftPanel + (leftPanel > 0 ? 2 : 0);
        this.titleLabelX = 17 + this.renderLeftPos - this.leftPos;
        this.inventoryLabelX = 8 + this.renderLeftPos - this.leftPos;
    }

    public int getXSize() {
        int leftPanel;
        return this.imageWidth + leftPanel + ((leftPanel = this.inventoryComponent.getWidth()) > 0 ? 2 : 0);
    }

    public void containerTick() {
        super.containerTick();
        this.inventoryComponent.tick();
    }

    public void render(GuiGraphics graphics, int p_98480_, int p_98481_, float p_98482_) {
        super.render(graphics, p_98480_, p_98481_, p_98482_);
        if (this.inventoryComponent.isVisibleTotal()) {
            for (int k = 82; k <= 135; ++k) {
                SimpleTableMenu.VariableSizeContainerSlot slot;
                Object object = ((SimpleTableMenu)this.menu).slots.get(k);
                if (!(object instanceof SimpleTableMenu.VariableSizeContainerSlot) || (slot = (SimpleTableMenu.VariableSizeContainerSlot)((Object)object)).isActive() || !slot.isExcessSlot() || slot.x < 0 || slot.getSlotIndex() >= 27 && !this.inventoryComponent.areSlotRowsFourToSixVisible()) continue;
                graphics.pose().translate(0.0f, 0.0f, 101.0f);
                if (this.excessSlotSprite == null) {
                    this.excessSlotSprite = (TextureAtlasSprite)this.minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(EXCESS_SLOT_BG);
                }
                graphics.blit(this.leftPos + slot.x, this.topPos + slot.y, 0, 16, 16, this.excessSlotSprite);
                graphics.pose().translate(0.0f, 0.0f, -101.0f);
            }
        }
        this.renderTooltip(graphics, p_98480_, p_98481_);
        this.inventoryComponent.renderTooltip(graphics, p_98480_, p_98481_);
        this.renderCustomizationTooltips(graphics, p_98480_, p_98481_);
    }

    protected void renderBg(GuiGraphics graphics, float p_98475_, int p_98476_, int p_98477_) {
        int i = this.renderLeftPos;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(this.getBackgroundImage(), i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public void renderBackground(GuiGraphics graphics, int p_297538_, int p_300104_, float p_298759_) {
        super.renderBackground(graphics, p_297538_, p_300104_, p_298759_);
        if (this.inventoryComponent.isVisibleTotal()) {
            this.inventoryComponent.render(graphics, p_297538_, p_300104_, p_298759_);
        }
    }

    protected void renderSlotContents(GuiGraphics guiGraphics, ItemStack itemstack, Slot slot, @Nullable String countString) {
        int x = slot.x;
        int y = slot.y;
        int index = slot.x + slot.y * this.imageWidth;
        if (slot.isFake()) {
            guiGraphics.renderFakeItem(itemstack, x, y, index);
        } else {
            guiGraphics.renderItem(itemstack, x, y, index);
        }
        float scale = 1.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        if (itemstack.getCount() > 99) {
            scale = 0.75f;
            dx = 4.0f;
            dy = 5.0f;
        }
        if (itemstack.getCount() > 999) {
            scale = 0.5f;
            dx = 14.0f;
            dy = 16.0f;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.pose().translate(dx, dy, 0.0f);
        x = (int)((float)x * (1.0f / scale));
        y = (int)((float)y * (1.0f / scale));
        guiGraphics.renderItemDecorations(this.font, itemstack, x, y, countString);
        guiGraphics.pose().popPose();
    }

    private void renderCustomizationTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.hoveredSlot == null || this.hoveredSlot.hasItem()) {
            return;
        }
        if (this.hoveredSlot instanceof SimpleTableMenu.CustomizationSlot && this.hoveredSlot.getSlotIndex() < ((SimpleTableMenu)this.getMenu()).getCustomizationSlotCount() && this.minecraft.screen != null) {
            if (SimpleTableCraftingScreen.hasShiftDown()) {
                if (this.tooltipCustomizationsFull == null) {
                    String itemKey = ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)((String)CommonConfig.AccessCustomizationItem.get())))).getDescriptionId();
                    String itemName = Language.getInstance().getOrDefault(itemKey);
                    this.tooltipCustomizationsFull = new ArrayList<Component>(15);
                    this.tooltipCustomizationsFull.add(this.tooltipCustomizationsTitle);
                    Arrays.stream(Language.getInstance().getOrDefault(this.getCustomizationTooltipPath()).replace("[ITEM]", itemName).split("\n")).forEach(text -> this.tooltipCustomizationsFull.add((Component)Component.literal((String)text).withStyle(ChatFormatting.DARK_GRAY)));
                }
                graphics.renderComponentTooltip(this.font, this.tooltipCustomizationsFull, mouseX, mouseY);
            } else {
                if (this.tooltipCustomizationsBrief == null) {
                    this.tooltipCustomizationsBrief = new ArrayList<Component>(2);
                    this.tooltipCustomizationsBrief.add(this.tooltipCustomizationsTitle);
                    this.tooltipCustomizationsBrief.add(this.tooltipCustomizationsShift);
                }
                graphics.renderComponentTooltip(this.font, this.tooltipCustomizationsBrief, mouseX, mouseY);
            }
        }
    }

    protected String getCustomizationTooltipPath() {
        return "message.workshop_for_handsome_adventurer.extension_slot1";
    }

    protected ResourceLocation getBackgroundImage() {
        if (CRAFTING_TABLE_LOCATION[0] == null) {
            SimpleTableCraftingScreen.CRAFTING_TABLE_LOCATION[0] = ResourceLocation.parse((String)"workshop_for_handsome_adventurer:textures/gui/gui_simple_table_0_slots.png");
            SimpleTableCraftingScreen.CRAFTING_TABLE_LOCATION[1] = ResourceLocation.parse((String)"workshop_for_handsome_adventurer:textures/gui/gui_simple_table_1_slots.png");
            SimpleTableCraftingScreen.CRAFTING_TABLE_LOCATION[2] = ResourceLocation.parse((String)"workshop_for_handsome_adventurer:textures/gui/gui_simple_table_2_slots.png");
        }
        if (this.backgroundImageLocation == null) {
            this.backgroundImageLocation = CRAFTING_TABLE_LOCATION[(Integer)CommonConfig.SimpleTableNumberOfSlots.get()];
        }
        return this.backgroundImageLocation;
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int left, int top, int button) {
        boolean flag = mouseX < (double)left || mouseY < (double)top || mouseX >= (double)(left + this.imageWidth) || mouseY >= (double)(top + this.imageHeight);
        return this.inventoryComponent.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth + this.inventoryComponent.getWidth() + 1, this.imageHeight, button) && flag;
    }

    protected void slotClicked(Slot p_98469_, int p_98470_, int p_98471_, ClickType p_98472_) {
        super.slotClicked(p_98469_, p_98470_, p_98471_, p_98472_);
        this.inventoryComponent.slotClicked(p_98469_);
    }

    public void removed() {
        this.inventoryComponent.removed();
        super.removed();
    }

    public boolean keyPressed(int p_97878_, int p_97879_, int p_97880_) {
        if (p_97878_ == 256) {
            this.minecraft.player.closeContainer();
        }
        if (this.inventoryComponent.isVisibleTotal() && this.inventoryComponent.keyPressed(p_97878_, p_97879_, p_97880_)) {
            return true;
        }
        return super.keyPressed(p_97878_, p_97879_, p_97880_);
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public Font getFont() {
        return this.font;
    }
}

