/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.blocks;

import java.util.List;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.integration.TetraHammerSupport;
import moonfather.workshop_for_handsome_adventurer.other.TableLockManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class SimpleTable
extends Block
implements EntityBlock {
    private final Component MessageInaccessible = Component.translatable((String)"message.workshop_for_handsome_adventurer.workshop_table_obscured");
    private MutableComponent Tooltip1;
    private MutableComponent Tooltip2;
    private static final VoxelShape SHAPE_TOP = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG1 = Block.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG2 = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)3.0);
    private static final VoxelShape SHAPE_LEG3 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)12.0, (double)3.0);
    private static final VoxelShape SHAPE_LEG4 = Block.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_TABLE = Shapes.or((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_LEG1, SHAPE_LEG2, SHAPE_LEG3, SHAPE_LEG4});
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.crafting");
    public static final BooleanProperty HAS_INVENTORY = BooleanProperty.create((String)"has_inventory");

    public SimpleTable(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public SimpleTable() {
        super(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava().mapColor(MapColor.COLOR_BROWN).pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HAS_INVENTORY, (Comparable)Boolean.valueOf(false)));
        this.Tooltip1 = Component.translatable((String)"block.workshop_for_handsome_adventurer.simple_table.tooltip1").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9966CC));
        this.Tooltip2 = Component.translatable((String)"block.workshop_for_handsome_adventurer.simple_table.tooltip2").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9966CC));
    }

    public VoxelShape getOcclusionShape(BlockState p_60578_, BlockGetter p_60579_, BlockPos p_60580_) {
        return SHAPE_TABLE;
    }

    public VoxelShape getBlockSupportShape(BlockState p_60581_, BlockGetter p_60582_, BlockPos p_60583_) {
        return SHAPE_TABLE;
    }

    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE_TABLE;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, context, list, tooltipFlag);
        list.add((Component)this.Tooltip1);
        list.add((Component)this.Tooltip2);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (this.isObscured(level, pos)) {
            if (level.isClientSide) {
                player.displayClientMessage(this.MessageInaccessible, true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (TableLockManager.isLocked(level, pos)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.workshop_for_handsome_adventurer.workshop_table_in_use", (Object[])new Object[]{TableLockManager.getPlayerName(level, pos).copy().withStyle(Style.EMPTY.withColor(-1118703))}), true);
            return InteractionResult.CONSUME;
        }
        if (ModList.get().isLoaded("tetra_tables") && !player.isCrouching() && TetraHammerSupport.isHammer(player.getMainHandItem())) {
            String id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
            String wood = id.substring(id.indexOf("simple_table") + 13);
            String newName = "tetra_table_" + wood;
            for (ResourceLocation key : BuiltInRegistries.BLOCK.keySet()) {
                if (!key.toString().endsWith(newName)) continue;
                level.setBlockAndUpdate(pos, ((Block)BuiltInRegistries.BLOCK.get(key)).defaultBlockState());
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        if (ModList.get().isLoaded("tetra") && !player.isCrouching() && TetraHammerSupport.isHammer(player.getMainHandItem())) {
            level.setBlockAndUpdate(pos, TetraHammerSupport.getWorkBench());
            return InteractionResult.CONSUME;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        player.awardStat(Stats.INTERACT_WITH_CRAFTING_TABLE);
        return InteractionResult.CONSUME;
    }

    private boolean isObscured(Level level, BlockPos pos) {
        if (!level.getFluidState(pos.above()).getType().equals(Fluids.EMPTY)) {
            return true;
        }
        VoxelShape s = level.getBlockState(pos.above()).getFaceOcclusionShape((BlockGetter)level, pos.above(), Direction.DOWN);
        if (s.isEmpty()) {
            return false;
        }
        double area = (s.max(Direction.Axis.X) - s.min(Direction.Axis.X)) * (s.max(Direction.Axis.Z) - s.min(Direction.Axis.Z));
        double lesserDim = Math.min(s.max(Direction.Axis.X) - s.min(Direction.Axis.X), s.max(Direction.Axis.Z) - s.min(Direction.Axis.Z));
        return area > 0.1875 || lesserDim > 0.1875;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity te = worldIn.getBlockEntity(pos);
            if (te instanceof SimpleTableBlockEntity) {
                SimpleTableBlockEntity entity = (SimpleTableBlockEntity)te;
                entity.DropAll();
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return Registration.SIMPLE_TABLE_BE.get().create(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return null;
    }

    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos blockPos) {
        return new SimpleMenuProvider((containerId, inventory, p_52231_) -> new SimpleTableMenu(containerId, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)blockPos), Registration.CRAFTING_SINGLE_MENU_TYPE.get()), CONTAINER_TITLE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HAS_INVENTORY});
    }
}

