/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources;

import com.google.common.base.Stopwatch;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public abstract class BaseResourcePack
implements PackResources {
    private final Map<ResourceLocation, String> dataCache = new ConcurrentHashMap<ResourceLocation, String>();
    private final PackType type;
    private final PackMetadataSection packMetadata;
    private Set<String> namespaces = null;
    private final Set<String> fixedNamespaces = Set.of("workshop_for_handsome_adventurer", "tetra_tables");

    protected BaseResourcePack(PackType type, int packFormat) {
        this.type = type;
        this.packMetadata = new PackMetadataSection((Component)Component.literal((String)this.packId()), packFormat, null);
    }

    protected abstract void buildResources(Map<ResourceLocation, String> var1);

    protected abstract boolean isNotOurNamespace(String var1);

    protected abstract boolean isNotOurThing(String var1);

    private void buildOnDemand() {
        if (this.namespaces == null) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.buildResources(this.dataCache);
            this.namespaces = this.dataCache.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet());
            stopwatch.stop();
        }
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... fileName) {
        this.buildOnDemand();
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation location) {
        if (this.isNotOurNamespace(location.getNamespace())) {
            return null;
        }
        if (this.isNotOurThing(location.getPath())) {
            return null;
        }
        if (!(this.namespaces != null || location.getNamespace().equals("workshop_for_handsome_adventurer") && (location.getPath().contains("spruce") || location.getPath().contains("en_us")))) {
            this.buildOnDemand();
        }
        if (type == this.type && this.dataCache.containsKey(location)) {
            return this.supplierForPath(location);
        }
        return null;
    }

    public void listResources(PackType type, String namespace, String path, PackResources.ResourceOutput output) {
        if (this.isNotOurNamespace(namespace)) {
            return;
        }
        if (this.isNotOurThing(path)) {
            return;
        }
        if (type == this.type) {
            this.buildOnDemand();
            this.dataCache.keySet().stream().filter(loc -> loc.getNamespace().equals(namespace)).filter(loc -> loc.getPath().startsWith(path)).forEach(loc -> output.accept(loc, this.supplierForPath((ResourceLocation)loc)));
        }
    }

    private IoSupplier<InputStream> supplierForPath(ResourceLocation loc) {
        return () -> new ByteArrayInputStream(this.dataCache.get(loc).getBytes(StandardCharsets.UTF_8));
    }

    public Set<String> getNamespaces(PackType type) {
        if (type != this.type) {
            return Set.of();
        }
        if (this.namespaces == null) {
            return this.fixedNamespaces;
        }
        return this.namespaces;
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer == PackMetadataSection.TYPE) {
            return (T)this.packMetadata;
        }
        return null;
    }

    public String packId() {
        return "test_dag:" + this.getClass().getSimpleName();
    }

    public void close() {
    }
}

