/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items;

import java.util.List;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomPrimary;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class WorkstationPlacerItem
extends Item {
    private final String woodType;
    private final MutableComponent Tooltip1 = Component.translatable((String)"item.workshop_for_handsome_adventurer.workstation_placer.tooltip1").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9966CC));
    private final MutableComponent Tooltip2 = Component.translatable((String)"item.workshop_for_handsome_adventurer.workstation_placer.tooltip2").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9966CC));
    protected String prefix = "";
    protected String hostModId = "workshop_for_handsome_adventurer";

    public WorkstationPlacerItem(String wood, Item.Properties properties) {
        super(properties);
        this.woodType = wood;
    }

    public WorkstationPlacerItem(String wood, Item.Properties properties, String hostMod, String prefix) {
        this(wood, properties);
        this.hostModId = hostMod;
        this.prefix = prefix;
    }

    public WorkstationPlacerItem(String wood) {
        this(wood, new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag advanced) {
        super.appendHoverText(itemStack, context, list, advanced);
        list.add((Component)this.Tooltip1);
        list.add((Component)this.Tooltip2);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos position = context.getClickedPos().relative(context.getClickedFace());
        boolean canPlace = this.checkCanPlace(context.getLevel(), position, context.getHorizontalDirection());
        if (!canPlace) {
            position = position.relative(context.getHorizontalDirection().getCounterClockWise());
            canPlace = this.checkCanPlace(context.getLevel(), position, context.getHorizontalDirection());
        }
        if (!canPlace) {
            if (context.getPlayer() != null) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"message.workshop_for_handsome_adventurer.no_room_for_workstation"), true);
            }
            return InteractionResult.FAIL;
        }
        Direction facingToSet = context.getHorizontalDirection().getOpposite();
        Direction right = context.getHorizontalDirection().getClockWise();
        Block bottomLeft = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)this.hostModId, (String)(this.prefix + "dual_table_bottom_left_" + this.woodType)));
        Block bottomRight = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)this.hostModId, (String)(this.prefix + "dual_table_bottom_right_" + this.woodType)));
        Block topLeft = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)this.hostModId, (String)(this.prefix + "dual_table_top_left_" + this.woodType)));
        Block topRight = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)this.hostModId, (String)(this.prefix + "dual_table_top_right_" + this.woodType)));
        context.getLevel().setBlock(position, (BlockState)((BlockState)bottomLeft.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facingToSet)).setValue((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(true)), 0);
        context.getLevel().setBlock(position.above(), (BlockState)((BlockState)topLeft.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facingToSet)).setValue((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(true)), 0);
        context.getLevel().setBlock(position.relative(right), (BlockState)((BlockState)bottomRight.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facingToSet)).setValue((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(true)), 0);
        context.getLevel().setBlock(position.above().relative(right), (BlockState)((BlockState)topRight.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facingToSet)).setValue((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(true)), 0);
        context.getLevel().setBlockAndUpdate(position, (BlockState)((BlockState)bottomLeft.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facingToSet)).setValue((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(false)));
        context.getLevel().setBlockAndUpdate(position.above(), (BlockState)((BlockState)topLeft.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facingToSet)).setValue((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(false)));
        context.getLevel().setBlockAndUpdate(position.relative(right), (BlockState)((BlockState)bottomRight.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facingToSet)).setValue((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(false)));
        context.getLevel().setBlockAndUpdate(position.above().relative(right), (BlockState)((BlockState)topRight.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facingToSet)).setValue((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(false)));
        if (context.getPlayer() != null && !context.getPlayer().isCreative()) {
            context.getItemInHand().shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return super.onItemUseFirst(stack, context);
    }

    private boolean checkCanPlace(Level level, BlockPos position, Direction horizontalDirection) {
        BlockState current = level.getBlockState(position);
        if (!current.isAir() && !current.canBeReplaced()) {
            return false;
        }
        current = level.getBlockState(position.above());
        if (!current.isAir() && !current.canBeReplaced()) {
            return false;
        }
        current = level.getBlockState(position.relative(horizontalDirection.getClockWise()));
        if (!current.isAir() && !current.canBeReplaced()) {
            return false;
        }
        current = level.getBlockState(position.above().relative(horizontalDirection.getClockWise()));
        return current.isAir() || current.canBeReplaced();
    }
}

