/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.BlockCheckmarkMessage;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.BlockPagingMessage;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskPageMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.network.PacketDistributor;

public class TaskListMessaging {
    public static final int ITEMS_PER_PAGE = 6;
    public static final Codec<TaskItemDTO> CODEC_FOR_ITEM = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("status").forGetter(TaskItemDTO::status), (App)Codec.STRING.fieldOf("line1").forGetter(TaskItemDTO::line1), (App)Codec.STRING.fieldOf("line2").forGetter(TaskItemDTO::line2)).apply((Applicative)instance, TaskItemDTO::new));
    public static final StreamCodec<ByteBuf, TaskItemDTO> STREAM_CODEC_FOR_ITEM = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, TaskItemDTO::status, (StreamCodec)ByteBufCodecs.STRING_UTF8, TaskItemDTO::line1, (StreamCodec)ByteBufCodecs.STRING_UTF8, TaskItemDTO::line2, TaskItemDTO::new);
    public static final Codec<TaskPageDTO> CODEC_FOR_PAGE = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("pageNumber").forGetter(TaskPageDTO::pageNumber), (App)Codec.list(CODEC_FOR_ITEM, (int)6, (int)6).fieldOf("value2").forGetter(TaskPageDTO::items)).apply((Applicative)instance, TaskPageDTO::new));
    public static final StreamCodec<ByteBuf, TaskPageDTO> STREAM_CODEC_FOR_PAGE = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, TaskPageDTO::pageNumber, (StreamCodec)STREAM_CODEC_FOR_ITEM.apply(ByteBufCodecs.list((int)6)), TaskPageDTO::items, TaskPageDTO::new);

    public static void sendPageToServer(TaskPageDTO page, TaskListExtraDTO extra) {
        PacketDistributor.sendToServer((CustomPacketPayload)new TaskPageMessage(page, extra), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendBlockClickPageRightToServer(BlockPos pos) {
        PacketDistributor.sendToServer((CustomPacketPayload)new BlockPagingMessage(pos, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendBlockClickPageLeftToServer(BlockPos pos) {
        PacketDistributor.sendToServer((CustomPacketPayload)new BlockPagingMessage(pos, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendBlockClickCheckmarkServer(BlockPos pos, int index, int page) {
        PacketDistributor.sendToServer((CustomPacketPayload)new BlockCheckmarkMessage(pos, index, page), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public record TaskPageDTO(int pageNumber, List<TaskItemDTO> items) {
        public TaskPageDTO(int pageNumber, List<TaskItemDTO> items) {
            this.pageNumber = pageNumber;
            this.items = new ArrayList<TaskItemDTO>(6);
            for (int k = 0; k < 6; ++k) {
                this.items.add(null);
            }
            for (int i = 0; i < 6; ++i) {
                if (items != null) {
                    this.items.set(i, new TaskItemDTO(items.get((int)i).status, items.get((int)i).line1, items.get((int)i).line2));
                    continue;
                }
                this.items.set(i, TaskItemDTO.empty());
            }
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.items);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TaskPageDTO) {
                TaskPageDTO other = (TaskPageDTO)obj;
                for (int i = 0; i < 6; ++i) {
                    if (this.items.get(i) == null) {
                        if (other.items.get(i) == null) continue;
                        return false;
                    }
                    if (this.items.get(i).equals(other.items.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public record TaskListExtraDTO(boolean mainHand, int lastPage, String itemName, BlockPos tilePos, boolean listIsInBlock) {
        public TaskListExtraDTO(boolean mainHand, int lastPage, String itemName) {
            this(mainHand, lastPage, itemName, BlockPos.ZERO, false);
        }

        public TaskListExtraDTO(BlockPos tilePos, int lastPage, String itemName) {
            this(true, lastPage, itemName, tilePos, true);
        }

        public TaskListExtraDTO(TaskListExtraDTO original, int page, String itemName) {
            this(original.mainHand(), page, itemName, original.tilePos(), original.listIsInBlock());
        }
    }

    public record TaskItemDTO(String status, String line1, String line2) {
        @Override
        public int hashCode() {
            return Objects.hash(this.status, this.line1, this.line2);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TaskItemDTO) {
                TaskItemDTO other = (TaskItemDTO)obj;
                return this.status.equals(other.status) && this.line1.equals(other.line1) && this.line2.equals(other.line2);
            }
            return false;
        }

        public static TaskItemDTO empty() {
            return new TaskItemDTO("e", "", "");
        }
    }
}

