/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BaseContainerBlockEntity
extends BlockEntity {
    private final List<ItemStack> items = new ArrayList<ItemStack>(9);
    private int capacity = 9;

    public BaseContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int value) {
        if (value > this.capacity) {
            this.capacity = value;
        }
    }

    protected void VerifyCapacity() {
        for (int i = this.items.size(); i < this.capacity; ++i) {
            this.items.add(ItemStack.f_41583_);
        }
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.VerifyCapacity();
        for (int i = 0; i < this.capacity; ++i) {
            CompoundTag tag = compoundTag.m_128469_("item" + i);
            if (tag.m_128441_("id")) {
                this.items.set(i, ItemStack.m_41712_((CompoundTag)tag));
                continue;
            }
            this.items.set(i, ItemStack.f_41583_);
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        this.saveInternal(compoundTag);
    }

    public CompoundTag saveInternal(CompoundTag compoundTag) {
        this.VerifyCapacity();
        for (int i = 0; i < this.capacity; ++i) {
            compoundTag.m_128365_("item" + i, (Tag)this.items.get(i).m_41739_(new CompoundTag()));
        }
        return compoundTag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        return this.saveInternal(new CompoundTag());
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void DropAll() {
        this.VerifyCapacity();
        for (int i = 0; i < this.capacity; ++i) {
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)this.items.get(i));
            this.ClearItem(i);
        }
    }

    public ItemStack GetItem(int slot) {
        this.VerifyCapacity();
        return this.items.get(slot);
    }

    public void DepositItem(int slot, ItemStack itemStack) {
        this.VerifyCapacity();
        this.items.set(slot, itemStack);
        this.m_6596_();
    }

    public void ClearItem(int slot) {
        this.VerifyCapacity();
        this.items.set(slot, ItemStack.f_41583_);
        this.m_6596_();
    }
}

