/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.container_translators;

import moonfather.workshop_for_handsome_adventurer.block_entities.container_translators.BaseContainerTranslator;
import moonfather.workshop_for_handsome_adventurer.block_entities.container_translators.IExcessSlotManager;
import net.minecraft.world.Container;

public class TetraBeltTranslator
extends BaseContainerTranslator
implements IExcessSlotManager {
    private final int tetraRows;

    public TetraBeltTranslator(Container wrapped) {
        super(wrapped, wrapped.m_6643_() / TetraBeltTranslator.GetRowWidth(wrapped) * 9);
        this.tetraRows = wrapped.m_6643_() / TetraBeltTranslator.GetRowWidth(wrapped);
    }

    public static int GetRowWidth(Container belt) {
        if (belt.m_6643_() % 8 == 0) {
            return 8;
        }
        if (belt.m_6643_() % 6 == 0) {
            return 6;
        }
        return 4;
    }

    @Override
    protected int translateVisibleToInternalSlot(int slot) {
        int row = this.tetraRows - slot / 9 - 1;
        if (row < 0) {
            row = 0;
        }
        int slotsPerRow = this.internal.m_6643_() / this.tetraRows;
        return row * slotsPerRow + slot % 9;
    }

    @Override
    protected int translateInternalToVisibleSlot(int slot) {
        int slotsPerRow = this.internal.m_6643_() / this.tetraRows;
        int row = this.tetraRows - slot / slotsPerRow - 1;
        return row * 9 + slot % slotsPerRow;
    }

    @Override
    public boolean isSlotSpecificallyDisabled(int slotIndex) {
        int slotsPerRow = this.internal.m_6643_() / this.tetraRows;
        return slotIndex % 9 >= slotsPerRow;
    }
}

