/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.PacketSender;
import moonfather.workshop_for_handsome_adventurer.block_entities.screen_components.SimpleButton;
import moonfather.workshop_for_handsome_adventurer.block_entities.screen_components.SlightlyNicerEditBox;
import moonfather.workshop_for_handsome_adventurer.block_entities.screens.SimpleTableCraftingScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class InventoryAccessComponent
implements Renderable,
GuiEventListener,
NarratableEntry {
    public static final int PANEL_WIDTH = 176;
    public static final int PANEL_HEIGHT_WITHOUT_TABS = 134;
    public static final int PANEL_HEIGHT_WITH_TABS = 166;
    protected static final ResourceLocation BG_CHEST_LOCATION_3_ROWS = new ResourceLocation("workshop_for_handsome_adventurer:textures/gui/left_panel_normal_chest.png");
    protected static final ResourceLocation BG_CHEST_LOCATION_6_ROWS = new ResourceLocation("workshop_for_handsome_adventurer:textures/gui/left_panel_double_chest.png");
    private final String renameTooltipKey = "message.workshop_for_handsome_adventurer.rename";
    private int xOffset;
    private final List<TabButton> tabButtons = Lists.newArrayList();
    private TabButton selectedTab;
    private EditBox renameBox;
    private SimpleButton renameButton;
    private boolean visible;
    private int tickCount = 0;
    private boolean widthTooNarrow2 = false;
    private SimpleTableCraftingScreen parent;
    private boolean tabsInitialized = false;
    private boolean slotRowsFourToSixVisible = false;
    private boolean slotsMoved = false;
    private boolean suppressRenameButton = false;

    public void init(SimpleTableCraftingScreen parent, boolean widthTooNarrow) {
        this.parent = parent;
        this.updateWidth(widthTooNarrow);
        this.parent.getMinecraft().f_91074_.f_36096_ = this.parent.m_6262_();
        this.visible = this.isVisibleAccordingToMenuData();
        if (this.visible) {
            this.initVisuals();
            this.hideIfScreenTooNarrow();
        }
        ((SimpleTableMenu)this.parent.m_6262_()).registerClientHandlerForDataSlot(0, this::onTabListChangedOnServer);
        ((SimpleTableMenu)this.parent.m_6262_()).registerClientHandlerForDataSlot(2, this::onContainerSizeChangedOnServer);
    }

    private void hideIfScreenTooNarrow() {
        ((SimpleTableMenu)this.parent.m_6262_()).setClientFlagScreenTooNarrow(this.widthTooNarrow2);
        ((SimpleTableMenu)this.parent.m_6262_()).updateAccessSlotsOnClient();
    }

    public void initVisuals() {
        this.xOffset = (this.parent.f_96543_ - this.parent.getImageWidth() - 176) / 2;
        int bottomY = (this.parent.f_96544_ - this.parent.getYSize()) / 2 + 166;
        if (this.renameBox == null) {
            this.renameBox = new SlightlyNicerEditBox(this.parent.getMinecraft().f_91062_, this.xOffset, bottomY - 18, 120, 14, (Component)Component.m_237113_((String)"Input box for new name for container"));
            this.renameBox.m_94199_(50);
            this.renameBox.m_94182_(false);
            this.renameBox.m_94194_(true);
            this.renameBox.m_94202_(0xCCCCCC);
            this.renameButton = new SimpleButton(this.xOffset, bottomY - 23, 25, 18, 181, 105, 19, BG_CHEST_LOCATION_3_ROWS, 256, 256, p_93751_ -> this.renameButtonClicked(), (Component)Component.m_237113_((String)"Rename container"));
            this.renameButton.setTooltipKey("message.workshop_for_handsome_adventurer.rename");
            this.renameButton.setTooltipInset((Component)Component.m_237113_((String)""));
            this.renameButton.f_93623_ = false;
        }
        this.renameBox.m_252865_(this.xOffset + 9);
        this.renameBox.m_253211_(bottomY - 18);
        this.renameButton.m_252865_(this.xOffset + 7 + this.renameBox.m_5711_() + 7);
        this.renameButton.m_253211_(bottomY - 23);
        if (!this.tabsInitialized) {
            ItemStack stack;
            this.tabButtons.clear();
            this.selectedTab = null;
            for (int i = 50; i < 81 && !(stack = ((Slot)((SimpleTableMenu)this.parent.m_6262_()).f_38839_.get(i)).m_7993_()).m_41619_(); i += 2) {
                TabButton button = new TabButton();
                button.m_93666_(stack.m_41786_());
                button.itemMain = stack;
                button.itemSub = ((Slot)((SimpleTableMenu)this.parent.m_6262_()).f_38839_.get(i + 1)).m_7993_();
                button.chestIndex = (i - 50) / 2;
                button.parent = this;
                this.tabButtons.add(button);
                if (button.chestIndex != ((SimpleTableMenu)this.parent.m_6262_()).selectedTab) continue;
                this.tabChanged(button, true);
            }
        }
        this.tabsInitialized = true;
        if (this.selectedTab == null && this.tabButtons.size() > 0) {
            this.tabChanged(this.tabButtons.get(0), true);
            ((SimpleTableMenu)this.parent.m_6262_()).updateAccessSlotsOnClient();
        }
        this.updateTabLocations();
    }

    private Boolean tabChanged(TabButton button, boolean dontSendToServer) {
        if (!((Object)((Object)button)).equals((Object)this.selectedTab)) {
            boolean canRenameContainer;
            if (this.selectedTab != null) {
                this.selectedTab.m_94635_(false);
            }
            button.m_94635_(true);
            this.selectedTab = button;
            ((SimpleTableMenu)this.parent.m_6262_()).selectedTab = button.chestIndex;
            if (!dontSendToServer) {
                PacketSender.sendTabChangeToServer(button.chestIndex);
            }
            this.renameButton.setTooltipInset(button.itemMain.m_41786_());
            this.renameBox.m_94144_("");
            this.renameBox.f_93624_ = canRenameContainer = (button.itemMain.m_41613_() & 4) == 0;
            this.renameButton.f_93624_ = canRenameContainer;
            this.slotRowsFourToSixVisible = (button.itemMain.m_41613_() & 2) == 2;
            return true;
        }
        return false;
    }

    private Boolean tabChanged(TabButton button) {
        return this.tabChanged(button, false);
    }

    private void onTabListChangedOnServer(Integer flag) {
        if (flag % 2 == 0) {
            return;
        }
        this.tabsInitialized = false;
        ((SimpleTableMenu)this.parent.m_6262_()).selectedTab = -1;
        this.initVisuals();
        if (this.tabButtons.size() > 0) {
            this.tabChanged(this.tabButtons.get(0));
        }
    }

    private void onContainerSizeChangedOnServer(Integer value) {
    }

    public boolean areSlotRowsFourToSixVisible() {
        return this.slotRowsFourToSixVisible;
    }

    public int getWidth() {
        if (!(!this.isVisibleAccordingToMenuData() || this.widthTooNarrow2 || this.tabsInitialized && this.tabButtons.size() <= 0)) {
            return 176;
        }
        return 0;
    }

    public void m_88315_(GuiGraphics graphics, int p_100320_, int p_100321_, float p_100322_) {
        if (this.isVisibleTotal()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_(0.0, 0.0, 100.0);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int x = this.parent.getGuiLeft();
            int y = (this.parent.f_96544_ - this.parent.getYSize()) / 2;
            graphics.m_280163_(this.getBackground(), x, y, 0.0f, 0.0f, 176, 166, 256, 256);
            this.renameBox.m_88315_(graphics, p_100320_, p_100321_, p_100322_);
            this.renameButton.m_88315_(graphics, p_100320_, p_100321_, p_100322_);
            for (StateSwitchingButton stateSwitchingButton : this.tabButtons) {
                stateSwitchingButton.m_88315_(graphics, p_100320_, p_100321_, p_100322_);
            }
            graphics.m_280168_().m_85849_();
        }
    }

    private ResourceLocation getBackground() {
        if (this.selectedTab != null && this.slotRowsFourToSixVisible) {
            return BG_CHEST_LOCATION_6_ROWS;
        }
        return BG_CHEST_LOCATION_3_ROWS;
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.isVisibleTotal()) {
            this.renameButton.renderTooltipsSeparately(graphics, this.parent.getFont(), mouseX, mouseY);
            for (StateSwitchingButton stateSwitchingButton : this.tabButtons) {
                if (!stateSwitchingButton.m_198029_()) continue;
                if (this.parent.getMinecraft().f_91080_ == null) break;
                graphics.m_280557_(this.parent.getFont(), stateSwitchingButton.m_6035_(), mouseX + 2, mouseY + 12);
                break;
            }
        }
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return this.visible ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput output) {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.tabButtons);
        Screen.NarratableSearchResult screen$narratablesearchresult = Screen.m_169400_((List)list, (NarratableEntry)null);
        if (screen$narratablesearchresult != null) {
            screen$narratablesearchresult.f_169420_.m_142291_(output.m_142047_());
        }
    }

    public boolean m_5953_(double p_100353_, double p_100354_) {
        return false;
    }

    public void m_93692_(boolean p_265728_) {
    }

    public boolean m_93696_() {
        return this.renameBox.m_93696_();
    }

    public void removed() {
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    public boolean isVisible() {
        return this.visible && this.tabButtons.size() > 0;
    }

    public boolean isVisibleTotal() {
        return this.isVisible() && (!this.tabsInitialized || this.tabButtons.size() > 0) && !this.widthTooNarrow2;
    }

    private boolean isVisibleAccordingToMenuData() {
        return ((SimpleTableMenu)this.parent.m_6262_()).showInventoryAccess();
    }

    protected void setVisible(boolean value) {
        boolean changeTab;
        boolean bl = changeTab = value && !this.visible;
        if (value) {
            this.initVisuals();
        }
        this.visible = value;
        this.updateSlotPositions();
        if (changeTab) {
            this.tabChanged(this.tabButtons.get(0), true);
        }
        this.hideIfScreenTooNarrow();
    }

    public void tick() {
        boolean flag;
        ++this.tickCount;
        if ((this.tickCount < 5 || this.tickCount % 10 == 6) && this.visible != (flag = this.isVisibleAccordingToMenuData())) {
            this.setVisible(flag);
            this.parent.setPositionsX();
        }
        if (this.isVisibleTotal() && this.renameBox != null) {
            this.renameBox.m_94120_();
            if (this.tickCount % 10 == 5) {
                this.suppressRenameButton = false;
                this.renameButton.f_93623_ = !this.renameBox.m_94155_().isEmpty() && (this.parent.getMinecraft().f_91074_.f_36078_ > 0 || this.parent.getMinecraft().f_91074_.m_7500_());
            }
        }
    }

    public boolean m_7933_(int p_94745_, int p_94746_, int p_94747_) {
        if (this.renameBox.m_93696_() && (this.renameBox.m_7933_(p_94745_, p_94746_, p_94747_) || this.renameBox.m_94204_())) {
            return true;
        }
        return super.m_7933_(p_94745_, p_94746_, p_94747_);
    }

    public boolean m_5534_(char p_94732_, int p_94733_) {
        if (this.renameBox.m_93696_() && this.renameBox.m_5534_(p_94732_, p_94733_)) {
            return true;
        }
        return super.m_5534_(p_94732_, p_94733_);
    }

    private void updateWidth(boolean widthTooNarrow) {
        if (this.widthTooNarrow2 != widthTooNarrow) {
            this.widthTooNarrow2 = widthTooNarrow;
            this.updateSlotPositions();
        }
    }

    private void updateSlotPositions() {
        block5: {
            block4: {
                if (!this.isVisibleTotal() || this.slotsMoved) break block4;
                for (int k = 0; k < ((SimpleTableMenu)this.parent.m_6262_()).f_38839_.size(); ++k) {
                    ((Slot)((SimpleTableMenu)this.parent.m_6262_()).f_38839_.get((int)k)).f_40220_ += 178;
                }
                this.slotsMoved = true;
                for (GuiEventListener c : this.parent.m_6702_()) {
                    if (!(c instanceof Button)) continue;
                    Button b = (Button)c;
                    b.m_252865_(b.m_252754_() + 178);
                }
                break block5;
            }
            if (this.isVisibleTotal() || !this.slotsMoved) break block5;
            for (int k = 0; k < ((SimpleTableMenu)this.parent.m_6262_()).f_38839_.size(); ++k) {
                ((Slot)((SimpleTableMenu)this.parent.m_6262_()).f_38839_.get((int)k)).f_40220_ -= 178;
            }
            this.slotsMoved = false;
            for (GuiEventListener c : this.parent.m_6702_()) {
                if (!(c instanceof Button)) continue;
                Button b = (Button)c;
                b.m_252865_(b.m_252754_() - 178);
            }
        }
    }

    private void updateTabLocations() {
        int startx = this.xOffset + 3;
        int starty = (this.parent.f_96544_ - this.parent.getYSize()) / 2;
        int counter = 0;
        boolean topRow = true;
        for (StateSwitchingButton stateSwitchingButton : this.tabButtons) {
            if (counter >= 8) {
                topRow = false;
                counter -= 8;
                starty += 163;
            }
            stateSwitchingButton.m_264152_(startx + 21 * counter, starty);
            ++counter;
            stateSwitchingButton.f_93624_ = true;
        }
    }

    public void slotClicked(@Nullable Slot slot) {
    }

    public boolean hasClickedOutside(double mouseX, double mouseY, int leftPos, int topPos, int width, int height, int mouseButton) {
        if (!this.isVisibleTotal()) {
            return true;
        }
        return mouseX < (double)leftPos || mouseX > (double)(leftPos + 176) || mouseY < (double)topPos || mouseY > (double)(topPos + height);
    }

    public boolean m_6375_(double v1, double v2, int mouseButton) {
        if (this.renameBox != null) {
            if (this.renameBox.m_5953_(v1, v2)) {
                this.renameBox.m_93692_(true);
                return true;
            }
            this.renameBox.m_93692_(false);
        }
        for (TabButton tabButton : this.tabButtons) {
            if (!tabButton.m_5953_(v1, v2)) continue;
            this.tabChanged(tabButton);
            return true;
        }
        if (this.renameButton != null && this.renameButton.f_93623_ && !this.suppressRenameButton && this.renameButton.m_5953_(v1, v2)) {
            this.suppressRenameButton = true;
            this.renameButton.m_6375_(v1, v2, mouseButton);
            return true;
        }
        return false;
    }

    private void renameButtonClicked() {
        PacketSender.sendRenameRequestToServer(this.renameBox.m_94155_());
        this.selectedTab.m_93666_((Component)Component.m_237113_((String)this.renameBox.m_94155_()));
        this.renameBox.m_94144_("");
    }

    private class TabButton
    extends StateSwitchingButton {
        private static final int TAB_ROW_COUNT = 8;
        public static final int WIDTH = 22;
        public static final int HEIGHT = 26;
        public InventoryAccessComponent parent;
        private ItemStack itemMain;
        private ItemStack itemSub;
        private int chestIndex;
        boolean checkedForSpecialScaling;
        boolean doSpecialScaling;
        private Function<TabButton, Boolean> handler;

        public TabButton() {
            super(0, 0, 22, 26, false);
            this.itemMain = ItemStack.f_41583_;
            this.itemSub = ItemStack.f_41583_;
            this.checkedForSpecialScaling = false;
            this.doSpecialScaling = false;
            this.handler = null;
            this.m_94624_(0, 168, 54, 0, BG_CHEST_LOCATION_3_ROWS);
        }

        public void m_87963_(GuiGraphics graphics, int p_100458_, int p_100459_, float p_100460_) {
            int texX = this.f_94610_;
            int texY = this.f_94611_;
            if (this.f_94609_) {
                texX += this.f_94612_;
            }
            if (this.m_198029_()) {
                texY += this.f_94613_;
            }
            if (this.chestIndex >= 8) {
                texX += 2 * this.f_94612_;
                texY += 3;
            }
            graphics.m_280163_(this.f_94608_, this.m_252754_(), this.m_252907_(), (float)texX, (float)texY, this.f_93618_, this.f_93619_, 256, 256);
            this.renderIcon(graphics);
        }

        private void renderIcon(GuiGraphics graphics) {
            int x = (this.parent.parent.f_96543_ - this.parent.parent.getXSize()) / 2;
            int y = (this.parent.parent.f_96544_ - this.parent.parent.getYSize()) / 2;
            int tabIndexInRow = this.chestIndex;
            int textureYAdjustment = 0;
            int textureYAdjustment2 = 0;
            if (this.chestIndex >= 8) {
                tabIndexInRow = this.chestIndex - 8;
                textureYAdjustment = 5;
                y = y + this.parent.parent.getYSize() - 26 - 39 - textureYAdjustment;
                textureYAdjustment2 = 0;
                --x;
            }
            if (!this.checkedForSpecialScaling) {
                this.doSpecialScaling = !(this.itemMain.m_41720_() instanceof BlockItem);
                this.checkedForSpecialScaling = true;
            }
            if (!this.doSpecialScaling) {
                graphics.m_280203_(this.itemMain, this.m_252754_() + 1, this.m_252907_() + 3 + textureYAdjustment2);
            } else {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.6666667f, 0.6666667f, 0.6666667f);
                graphics.m_280168_().m_85837_(0.0, 0.0, 100.0);
                graphics.m_280203_(this.itemMain, (int)((double)(x + tabIndexInRow * 21 + 7) * 1.5), (int)((double)(y + 5) * 1.5));
                graphics.m_280168_().m_85849_();
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(0.6666667f, 0.6666667f, 0.6666667f);
            graphics.m_280168_().m_85837_(0.0, 0.0, 100.0);
            graphics.m_280203_(this.itemSub, (int)((double)(x + tabIndexInRow * 21 + 13) * 1.5), (int)((double)(y + 12) * 1.5));
            graphics.m_280168_().m_85849_();
        }

        public void setClickHandler(Function<TabButton, Boolean> handler) {
            this.handler = handler;
        }

        public boolean m_6375_(double p_93641_, double p_93642_, int p_93643_) {
            if (this.handler != null) {
                return this.handler.apply(this);
            }
            return super.m_6375_(p_93641_, p_93642_, p_93643_);
        }
    }
}

