/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.CustomTripletSupport;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.DynamicAssetConfig;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodTypeLister {
    private static List<String> ids = null;
    private static List<String> idsWithSpecials = null;
    private static final HashMap<String, String> woodToHostMap = new HashMap();
    private static final List<ResourceLocation> dupeIds = new ArrayList<ResourceLocation>();

    public static void reset() {
        ids = null;
    }

    public static List<String> getWoodIds(boolean includeSpecials) {
        WoodTypeLister.generateIfNeeded();
        return includeSpecials ? idsWithSpecials : ids;
    }

    public static List<String> getWoodIds() {
        WoodTypeLister.generateIfNeeded();
        return idsWithSpecials;
    }

    public static void generateIfNeeded() {
        if (ids == null) {
            Stopwatch s = Stopwatch.createStarted();
            ids = new ArrayList<String>();
            ids.add("acacia");
            woodToHostMap.put("acacia", "minecraft");
            ids.add("bamboo");
            woodToHostMap.put("bamboo", "minecraft");
            ids.add("crimson");
            woodToHostMap.put("crimson", "minecraft");
            ids.add("warped");
            woodToHostMap.put("warped", "minecraft");
            String mc = "minecraft";
            String planks = "_planks";
            String slab = "_slab";
            String vertical = "vertical";
            String LOG1 = "stripped_";
            String LOG2 = "_log";
            for (ResourceLocation id : ForgeRegistries.BLOCKS.getKeys()) {
                if (id.m_135827_().equals("minecraft") || !id.m_135815_().endsWith("_planks") || id.m_135815_().contains("vertical")) continue;
                String wood = id.m_135815_().replace("_planks", "");
                if (DynamicAssetConfig.isBlackListed(id.m_135827_(), wood) || !ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(id.m_135827_(), id.m_135815_().replace("_planks", "_slab")))) continue;
                if (!ids.contains(wood) && !Registration.woodTypes.contains(wood)) {
                    String substitute;
                    if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(id.m_135827_(), "stripped_" + wood + "_log")) && ((substitute = DynamicAssetConfig.getLogRecipeSubstitution(wood)) == null || !ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(substitute)))) continue;
                    ids.add(wood);
                    woodToHostMap.put(wood, id.m_135827_());
                    continue;
                }
                if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(id.m_135827_(), "stripped_" + wood + "_log"))) continue;
                dupeIds.add(new ResourceLocation(id.m_135827_(), wood));
            }
            s.stop();
            idsWithSpecials = new ArrayList<String>(ids);
            for (DynamicAssetConfig.WoodSet woodSet : DynamicAssetConfig.getWoodSetsWithDumbassNames()) {
                String substitute;
                if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(woodSet.modId(), woodSet.planks())) || !ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(woodSet.modId(), woodSet.slab())) || !ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(woodSet.modId(), woodSet.log())) && ((substitute = DynamicAssetConfig.getLogRecipeSubstitution(woodSet.planks())) == null || !ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(substitute)))) continue;
                idsWithSpecials.add(CustomTripletSupport.addPrefixTo(woodSet.planks()));
                woodToHostMap.put(CustomTripletSupport.addPrefixTo(woodSet.planks()), woodSet.modId());
            }
        }
    }

    public static String getHostMod(String wood) {
        return woodToHostMap.get(wood);
    }

    public static List<ResourceLocation> getDuplicateWoods() {
        return dupeIds;
    }
}

