/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources.helpers;

import java.util.List;
import java.util.Map;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.AssetReader;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.DynamicAssetConfig;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeLister;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;

public class RecipeWriter {
    private static final String JOIN = "%s:%s";
    private static final String JOIN3 = "%s:%s%s";
    private static final String TEMPLATE_LOG = "%s:stripped_%s_log";
    private static final String[] allRecipes = new String[]{"recipes/book_shelf_double_spruce.json", "recipes/book_shelf_minimal_spruce.json", "recipes/book_shelf_open_double_spruce.json", "recipes/book_shelf_open_minimal_from_double_spruce.json", "recipes/book_shelf_open_minimal_spruce.json", "recipes/book_shelf_with_lanterns_spruce.json", "recipes/potion_shelf_spruce.json", "recipes/simple_table_normal_spruce.json", "recipes/simple_table_replacement_spruce.json", "recipes/tool_rack_double_spruce.json", "recipes/tool_rack_framed_spruce.json", "recipes/tool_rack_pframed_spruce.json", "recipes/tool_rack_single_from_multi_spruce.json", "recipes/tool_rack_single_spruce.json", "recipes/workstation_placer_spruce.json"};
    private static final List<String> conversionRecipes = List.of("recipes/book_shelf_minimal_spruce.json", "recipes/book_shelf_open_double_spruce.json", "recipes/book_shelf_open_minimal_from_double_spruce.json", "recipes/book_shelf_open_minimal_spruce.json", "recipes/book_shelf_with_lanterns_spruce.json", "recipes/tool_rack_double_spruce.json", "recipes/tool_rack_pframed_spruce.json", "recipes/tool_rack_single_from_multi_spruce.json");

    public static void writeFiles(Map<ResourceLocation, String> cache) {
        String SPRUCE = "spruce";
        for (String file : allRecipes) {
            String newRecipe;
            String original = AssetReader.getInstance(PackType.SERVER_DATA, "workshop_for_handsome_adventurer").getText(new ResourceLocation("workshop_for_handsome_adventurer", file));
            for (String wood : WoodTypeLister.getWoodIds()) {
                newRecipe = original.replace("minecraft:stripped_spruce_log", RecipeWriter.getStrippedLog(wood)).replace("minecraft:spruce_slab", RecipeWriter.getSlab(wood)).replace("minecraft:spruce_planks", RecipeWriter.getPlanks(wood)).replace("spruce", wood);
                cache.put(new ResourceLocation("workshop_for_handsome_adventurer", file.replace("spruce", wood)), newRecipe);
            }
            if (conversionRecipes.contains(file)) continue;
            for (ResourceLocation duplicate : WoodTypeLister.getDuplicateWoods()) {
                newRecipe = original.replace("minecraft:stripped_spruce", duplicate.m_135827_() + ":stripped_" + duplicate.m_135815_()).replace("minecraft:spruce", duplicate.toString()).replace("spruce", duplicate.m_135815_());
                cache.put(new ResourceLocation("workshop_for_handsome_adventurer", file.replace("spruce", duplicate.m_135815_() + "_" + duplicate.m_135827_())), newRecipe);
            }
        }
    }

    private static String getStrippedLog(String wood) {
        String sub = WoodTypeManager.getLogRecipeSubstitute(wood);
        if (sub != null) {
            return sub;
        }
        DynamicAssetConfig.WoodSet specialSet = DynamicAssetConfig.getWoodSet(wood);
        if (specialSet != null) {
            return JOIN.formatted(specialSet.modId(), specialSet.log());
        }
        return TEMPLATE_LOG.formatted(WoodTypeLister.getHostMod(wood), wood);
    }

    private static String getSlab(String wood) {
        DynamicAssetConfig.WoodSet specialSet = DynamicAssetConfig.getWoodSet(wood);
        if (specialSet != null) {
            return JOIN.formatted(specialSet.modId(), specialSet.slab());
        }
        return JOIN3.formatted(WoodTypeLister.getHostMod(wood), wood, "_slab");
    }

    static String getPlanks(String wood) {
        DynamicAssetConfig.WoodSet specialSet = DynamicAssetConfig.getWoodSet(wood);
        if (specialSet != null) {
            return JOIN.formatted(specialSet.modId(), specialSet.planks());
        }
        return JOIN3.formatted(WoodTypeLister.getHostMod(wood), wood, "_planks");
    }
}

