/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.integration;

import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.block_entities.BookShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.PotionShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.BookShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.integration.WailaBaseProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TOPInfoProvider
extends WailaBaseProvider
implements IProbeInfoProvider {
    private int optionsCacheTime = 0;
    private boolean optionBooks = false;
    private boolean optionsTools = false;

    public ResourceLocation getID() {
        return new ResourceLocation("workshop_for_handsome_adventurer", "top_shelf");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData probeHitData) {
        if (this.optionsCacheTime <= 0) {
            this.optionsTools = (Boolean)OptionsHolder.CLIENT.DetailedWailaInfoForEnchantedTools.get();
            this.optionBooks = (Boolean)OptionsHolder.CLIENT.DetailedWailaInfoForEnchantedBooks.get();
            this.optionsCacheTime = 55;
        }
        if (blockState.m_60734_() instanceof PotionShelf) {
            int slot = PotionShelf.getPotionShelfSlot(new BlockHitResult(probeHitData.getHitVec(), ((Direction)blockState.m_61143_((Property)PotionShelf.FACING)).m_122424_(), probeHitData.getPos(), true));
            PotionShelfBlockEntity shelf = (PotionShelfBlockEntity)level.m_7702_(probeHitData.getPos());
            int count = shelf.GetRemainingItems(slot);
            int total = shelf.GetRemainingRoom(slot) + count;
            probeInfo.text((Component)Component.m_237110_((String)"message.workshop_for_handsome_adventurer.shelf_probe_tooltip", (Object[])new Object[]{count, total}).m_130948_(Style.f_131099_.m_178520_(0xAA77DD)));
            return;
        }
        if (blockState.m_60734_() instanceof BookShelf) {
            int slot = BookShelf.getBookShelfSlot((BookShelf)blockState.m_60734_(), new BlockHitResult(probeHitData.getHitVec(), ((Direction)blockState.m_61143_((Property)BookShelf.FACING)).m_122424_(), probeHitData.getPos(), true));
            if (slot >= 0) {
                List<Component> enchantments;
                BookShelfBlockEntity shelf = (BookShelfBlockEntity)level.m_7702_(probeHitData.getPos());
                ItemStack book = shelf.GetItem(slot);
                probeInfo.horizontal().item(book).vertical().padding(2, 4).itemLabel(book);
                if (this.optionBooks && (enchantments = this.getEnchantmentParts(book)) != null) {
                    for (int i = 0; i < enchantments.size(); i += 2) {
                        probeInfo.horizontal().padding(30, 4).text(enchantments.get(i)).text(enchantments.get(i + 1));
                    }
                }
            }
            return;
        }
        Block shelf = blockState.m_60734_();
        if (shelf instanceof ToolRack) {
            int slot;
            ToolRack block = (ToolRack)shelf;
            ToolRackBlockEntity rack = (ToolRackBlockEntity)level.m_7702_(probeHitData.getPos());
            if (rack != null) {
                slot = ToolRack.getToolRackSlot(block, new BlockHitResult(probeHitData.getHitVec(), ((Direction)blockState.m_61143_((Property)PotionShelf.FACING)).m_122424_(), probeHitData.getPos(), true));
            } else {
                rack = (ToolRackBlockEntity)level.m_7702_(probeHitData.getPos().m_7494_());
                slot = ToolRack.getToolRackSlot(block, new BlockHitResult(probeHitData.getHitVec(), ((Direction)blockState.m_61143_((Property)PotionShelf.FACING)).m_122424_(), probeHitData.getPos().m_7494_(), true));
            }
            ItemStack tool = rack.GetItem(slot);
            if (slot >= 0 && !tool.m_41619_()) {
                List<Component> enchantments;
                probeInfo.horizontal().item(tool).vertical().padding(2, 4).itemLabel(tool);
                if (this.optionsTools && (enchantments = this.getEnchantmentParts(tool)) != null) {
                    for (int i = 0; i < enchantments.size(); i += 2) {
                        probeInfo.horizontal().padding(30, 4).text(enchantments.get(i)).text(enchantments.get(i + 1));
                    }
                }
            }
        }
    }
}

