/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.blocks;

import java.util.HashMap;
import java.util.Map;
import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.TaskListBlockEntity;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.TaskListItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TaskListPanel
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty EMPTY = BooleanProperty.m_61465_((String)"empty");
    private static final VoxelShape SHAPE_PLANK1S = Block.m_49796_((double)1.5, (double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)1.0);
    private static final VoxelShape SHAPE_PLANK1W = Block.m_49796_((double)15.0, (double)0.0, (double)1.5, (double)16.0, (double)16.0, (double)14.5);
    private static final VoxelShape SHAPE_PLANK1N = Block.m_49796_((double)1.5, (double)0.0, (double)15.0, (double)14.5, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_PLANK1E = Block.m_49796_((double)0.0, (double)0.0, (double)1.5, (double)1.0, (double)16.0, (double)14.5);
    protected final Map<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>(4);

    public TaskListPanel() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(0.3f, 0.6f).m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283748_).m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)EMPTY, (Comparable)Boolean.valueOf(true)));
        this.PrepareListOfShapes();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{EMPTY});
    }

    protected void PrepareListOfShapes() {
        this.shapes.put(Direction.NORTH, SHAPE_PLANK1N);
        this.shapes.put(Direction.EAST, SHAPE_PLANK1E);
        this.shapes.put(Direction.SOUTH, SHAPE_PLANK1S);
        this.shapes.put(Direction.WEST, SHAPE_PLANK1W);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.shapes.get(state.m_61143_((Property)FACING));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43719_() == Direction.DOWN || context.m_43719_() == Direction.UP) {
            return null;
        }
        BlockState result = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
        if (this.m_7898_(result, (LevelReader)context.m_43725_(), context.m_8083_())) {
            return result;
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos target = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
        return world.m_8055_(target).m_60783_((BlockGetter)world, target, (Direction)state.m_61143_((Property)FACING));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TaskListBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return null;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity be = worldIn.m_7702_(pos);
            if (be instanceof TaskListBlockEntity) {
                TaskListBlockEntity panel = (TaskListBlockEntity)be;
                Block.m_152435_((Level)worldIn, (BlockPos)pos, (Direction)((Direction)state.m_61143_((Property)FACING)), (ItemStack)panel.getItemForDrop());
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos rackPos, Block block, BlockPos wallPos, boolean something) {
        super.m_6861_(state, level, rackPos, block, wallPos, something);
        if (!this.m_7898_(state, (LevelReader)level, rackPos)) {
            level.m_46961_(rackPos, false);
        }
    }

    public PushReaction getPistonPushReaction(BlockState p_60584_) {
        return PushReaction.DESTROY;
    }

    public ItemStack m_7397_(BlockGetter p_49823_, BlockPos p_49824_, BlockState p_49825_) {
        return TaskListItem.Utility.createInstance();
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TaskListBlockEntity) {
            TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity;
            return !tile.isFireResistant();
        }
        return super.isFlammable(state, level, pos, direction);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        TaskListBlockEntity tile;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TaskListBlockEntity && (tile = (TaskListBlockEntity)blockEntity).isFireResistant()) {
            return 0;
        }
        return 20;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (hand.equals((Object)InteractionHand.OFF_HAND)) {
            return InteractionResult.PASS;
        }
        if (!((Boolean)OptionsHolder.CLIENT.TaskListItemsAreDrawnOnWall.get()).booleanValue()) {
            if (level.f_46443_) {
                BlockEntity blockEntity2 = level.m_7702_(pos);
                if (blockEntity2 instanceof TaskListBlockEntity) {
                    TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity2;
                    tile.invokeGUI();
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)TaskListItem.Utility.ourItemBasic()));
            return InteractionResult.CONSUME;
        }
        if (!level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        double y = hitResult.m_82450_().f_82480_ - (double)hitResult.m_82425_().m_123342_();
        double x = 0.0;
        if (hitResult.m_82434_().m_122434_().equals((Object)Direction.Axis.X)) {
            x = hitResult.m_82450_().m_7094_() - (double)hitResult.m_82425_().m_123343_();
            if (hitResult.m_82434_().equals((Object)Direction.EAST)) {
                x = 1.0 - x;
            }
        } else {
            x = hitResult.m_82450_().m_7096_() - (double)hitResult.m_82425_().m_123341_();
            if (hitResult.m_82434_().equals((Object)Direction.NORTH)) {
                x = 1.0 - x;
            }
        }
        if (y <= 0.15 && x <= 0.25 && (blockEntity = level.m_7702_(pos)) instanceof TaskListBlockEntity) {
            TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity;
            tile.onClientArrowPrev();
            return InteractionResult.SUCCESS;
        }
        if (y <= 0.15 && x >= 0.75 && (blockEntity = level.m_7702_(pos)) instanceof TaskListBlockEntity) {
            TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity;
            tile.onClientArrowNext();
            return InteractionResult.SUCCESS;
        }
        double yFromTop = 1.0 - y;
        float vOffset = -0.04321f;
        for (int i = 0; i < 6; ++i) {
            if (!(x >= 0.125) || !(x <= 0.25) || !(yFromTop >= (double)((float)(3 + 2 * i) / 16.0f + vOffset)) || !(yFromTop <= (double)((float)(3 + 2 * i + 2) / 16.0f + vOffset))) continue;
            BlockEntity blockEntity3 = level.m_7702_(pos);
            if (blockEntity3 instanceof TaskListBlockEntity) {
                TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity3;
                tile.checkmarkClickedOnBlock(i);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

