/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data;

import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.BasicBlockEntity;
import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.TaskListBlockEntity;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.TaskListItem;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.BlockCheckmarkMessage;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.BlockPagingMessage;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListComponent;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListMessaging;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskPageMessage;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class TaskListMessageHandler {
    public static void handleItemMessage(TaskPageMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        try {
            contextSupplier.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                TaskListMessageHandler.findAndUpdateItemStack(player, message.getPage(), message.getExtra());
            });
            contextSupplier.get().setPacketHandled(true);
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Networking error in WFHA mod, msg654:  \n" + e.getMessage());
        }
    }

    private static void findAndUpdateItemStack(ServerPlayer sp, TaskListMessaging.TaskPageDTO value, TaskListMessaging.TaskListExtraDTO extra) {
        ItemStack itemStack = ItemStack.f_41583_;
        TaskListBlockEntity tile = null;
        if (!extra.listIsInBlock()) {
            itemStack = extra.mainHand() ? sp.m_21205_() : sp.m_21206_();
        } else {
            BlockEntity blockEntity = sp.m_9236_().m_7702_(extra.tilePos());
            if (blockEntity instanceof TaskListBlockEntity) {
                TaskListBlockEntity tileValue = (TaskListBlockEntity)blockEntity;
                itemStack = tileValue.getItem();
                tile = tileValue;
            }
        }
        if (!TaskListItem.Utility.isOurItem(itemStack)) {
            sp.m_5661_((Component)Component.m_237113_((String)"error: didn't find task list."), false);
            return;
        }
        TaskListMessageHandler.updateItemStack(itemStack, value, extra);
        if (extra.listIsInBlock() && tile != null) {
            tile.setItem(itemStack);
            BasicBlockEntity.sendUpdated(sp.m_9236_(), extra.tilePos());
        }
    }

    private static void updateItemStack(ItemStack itemStack, TaskListMessaging.TaskPageDTO value, TaskListMessaging.TaskListExtraDTO extra) {
        TaskListComponent updated;
        int pageNumber = value.pageNumber();
        TaskListComponent old = TaskListItem.Component.get(itemStack);
        if (old != null) {
            updated = old.makeCopy(value.pageNumber(), extra.lastPage());
        } else {
            updated = new TaskListComponent(1, 1, null);
            pageNumber = 1;
        }
        updated.updatePage(pageNumber, value);
        updated.setLastPage(pageNumber);
        TaskListItem.Component.set(itemStack, updated);
        TaskListItem.Utility.setTitle(itemStack, extra.itemName());
    }

    public static void handleBlockPagingMessage(BlockPagingMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        try {
            contextSupplier.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                BlockEntity patt3919$temp = player.m_9236_().m_7702_(message.getPos());
                if (patt3919$temp instanceof TaskListBlockEntity) {
                    TaskListBlockEntity tile = (TaskListBlockEntity)patt3919$temp;
                    if (message.isMovingRight()) {
                        tile.onArrowNext();
                    } else {
                        tile.onArrowPrev();
                    }
                }
            });
            contextSupplier.get().setPacketHandled(true);
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Networking error in WFHA mod, msg656:  \n" + e.getMessage());
        }
    }

    public static void handleBlockCheckmarkMessage(BlockCheckmarkMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        try {
            contextSupplier.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                BlockEntity patt5006$temp = player.m_9236_().m_7702_(message.getPos());
                if (patt5006$temp instanceof TaskListBlockEntity) {
                    TaskListBlockEntity tile = (TaskListBlockEntity)patt5006$temp;
                    tile.updateCheckmark(message.getIndex(), message.getPageNumber());
                }
            });
            contextSupplier.get().setPacketHandled(true);
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Networking error in WFHA mod, msg657:  \n" + e.getMessage());
        }
    }
}

