/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources.helpers;

import java.util.List;
import java.util.Map;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.AssetReader;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeCommonManager;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeLister;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;

public class RecipeWriter {
    private static final String JOIN = "%s:%s";
    private static final String JOIN3 = "%s:%s%s";
    private static final String TEMPLATE_LOG = "%s:stripped_%s_log";
    private static final String[] allRecipes = new String[]{"recipe/book_shelf_double_spruce.json", "recipe/book_shelf_minimal_spruce.json", "recipe/book_shelf_open_double_spruce.json", "recipe/book_shelf_open_minimal_from_double_spruce.json", "recipe/book_shelf_open_minimal_spruce.json", "recipe/book_shelf_with_lanterns_spruce.json", "recipe/potion_shelf_spruce.json", "recipe/simple_table_normal_spruce.json", "recipe/simple_table_replacement_spruce.json", "recipe/tool_rack_double_spruce.json", "recipe/tool_rack_framed_spruce.json", "recipe/tool_rack_pframed_spruce.json", "recipe/tool_rack_single_from_multi_spruce.json", "recipe/tool_rack_single_spruce.json", "recipe/workstation_placer_spruce.json"};
    private static final List<String> conversionRecipes = List.of("recipe/book_shelf_minimal_spruce.json", "recipe/book_shelf_open_double_spruce.json", "recipe/book_shelf_open_minimal_from_double_spruce.json", "recipe/book_shelf_open_minimal_spruce.json", "recipe/book_shelf_with_lanterns_spruce.json", "recipe/tool_rack_double_spruce.json", "recipe/tool_rack_pframed_spruce.json", "recipe/tool_rack_single_from_multi_spruce.json");

    public static void writeFiles(Map<ResourceLocation, String> cache) {
        String SPRUCE = "spruce";
        for (String file : allRecipes) {
            String newRecipe;
            String original = AssetReader.getInstance(PackType.SERVER_DATA, "workshop_for_handsome_adventurer").getText(ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)file));
            String filePrefix = file.substring("recipe/".length(), file.length() - "spruce.json".length());
            for (String wood : WoodTypeLister.getWoodIds()) {
                newRecipe = original.replace("minecraft:stripped_spruce_log", RecipeWriter.getStrippedLog(wood)).replace("minecraft:spruce_slab", RecipeWriter.getSlab(wood)).replace("minecraft:spruce_planks", RecipeWriter.getPlanks(wood)).replace(filePrefix + "spruce", filePrefix + wood);
                cache.put(ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)file.replace("spruce", wood)), newRecipe);
            }
            if (conversionRecipes.contains(file)) continue;
            for (ResourceLocation duplicate : WoodTypeLister.getDuplicateWoods()) {
                newRecipe = original.replace("minecraft:stripped_spruce", duplicate.getNamespace() + ":stripped_" + duplicate.getPath()).replace("minecraft:spruce", duplicate.toString()).replace(filePrefix + "spruce", filePrefix + duplicate.getPath());
                cache.put(ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)file.replace("spruce", duplicate.getPath() + "_" + duplicate.getNamespace())), newRecipe);
            }
        }
    }

    private static String getStrippedLog(String wood) {
        String sub = WoodTypeCommonManager.getLogRecipeSubstitute(wood);
        if (sub != null) {
            return sub;
        }
        WoodTypeCommonManager.WoodSet specialSet = WoodTypeCommonManager.getWoodSet(wood);
        if (specialSet != null) {
            return JOIN.formatted(specialSet.modId(), specialSet.log());
        }
        return TEMPLATE_LOG.formatted(WoodTypeLister.getHostMod(wood), wood);
    }

    private static String getSlab(String wood) {
        WoodTypeCommonManager.WoodSet specialSet = WoodTypeCommonManager.getWoodSet(wood);
        if (specialSet != null) {
            return JOIN.formatted(specialSet.modId(), specialSet.slab());
        }
        return JOIN3.formatted(WoodTypeLister.getHostMod(wood), wood, "_slab");
    }

    static String getPlanks(String wood) {
        WoodTypeCommonManager.WoodSet specialSet = WoodTypeCommonManager.getWoodSet(wood);
        if (specialSet != null) {
            return JOIN.formatted(specialSet.modId(), specialSet.planks());
        }
        return JOIN3.formatted(WoodTypeLister.getHostMod(wood), wood, "_planks");
    }
}

