/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.integration;

import java.util.ArrayList;
import moonfather.workshop_for_handsome_adventurer.block_entities.PotionShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ITextElement;

public class JadePotionTooltipProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    private static final JadePotionTooltipProvider instance = new JadePotionTooltipProvider();
    private final ResourceLocation pluginId = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"jade_plugin1");

    public static JadePotionTooltipProvider getInstance() {
        return instance;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        int slot;
        PotionShelfBlockEntity shelf;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof PotionShelfBlockEntity && !(shelf = (PotionShelfBlockEntity)blockEntity).GetItem(slot = PotionShelf.getPotionShelfSlot((BlockHitResult)accessor.getHitResult())).isEmpty()) {
            int count = accessor.getServerData().contains("Bottles" + slot) ? accessor.getServerData().getInt("Bottles" + slot) : shelf.GetRemainingItems(slot).intValue();
            ArrayList<ITextElement> list = new ArrayList<ITextElement>(2);
            list.add(IElementHelper.get().text((Component)Component.literal((String)(" " + count + "x  "))));
            list.add(IElementHelper.get().text(shelf.GetItem(slot).getDisplayName()));
            tooltip.add(list);
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor blockAccessor) {
        for (int i = 0; i < 6; ++i) {
            int bottles = ((PotionShelfBlockEntity)blockAccessor.getBlockEntity()).GetRemainingItems(i);
            data.putInt("Bottles" + i, bottles);
        }
    }

    public ResourceLocation getUid() {
        return this.pluginId;
    }
}

