/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.integration;

import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import moonfather.workshop_for_handsome_adventurer.ClientConfig;
import moonfather.workshop_for_handsome_adventurer.block_entities.BookShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.PotionShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.BookShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.integration.WailaBaseProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TOPInfoProvider
extends WailaBaseProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"top_shelf");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData probeHitData) {
        if (blockState.getBlock() instanceof PotionShelf) {
            int slot = PotionShelf.getPotionShelfSlot(new BlockHitResult(probeHitData.getHitVec(), ((Direction)blockState.getValue((Property)PotionShelf.FACING)).getOpposite(), probeHitData.getPos(), true));
            PotionShelfBlockEntity shelf = (PotionShelfBlockEntity)level.getBlockEntity(probeHitData.getPos());
            int count = shelf.GetRemainingItems(slot);
            int total = shelf.GetRemainingRoom(slot) + count;
            probeInfo.text((Component)Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_probe_tooltip", (Object[])new Object[]{count, total}).withStyle(Style.EMPTY.withColor(0xAA77DD)));
            return;
        }
        if (blockState.getBlock() instanceof BookShelf) {
            int slot = BookShelf.getBookShelfSlot((BookShelf)blockState.getBlock(), new BlockHitResult(probeHitData.getHitVec(), ((Direction)blockState.getValue((Property)BookShelf.FACING)).getOpposite(), probeHitData.getPos(), true));
            if (slot >= 0) {
                List<Component> enchantments;
                BookShelfBlockEntity shelf = (BookShelfBlockEntity)level.getBlockEntity(probeHitData.getPos());
                ItemStack book = shelf.GetItem(slot);
                probeInfo.horizontal().item(book).vertical().padding(2, 4).itemLabel(book);
                if (ClientConfig.detailedWailaInfoForEnchantedBooks && (enchantments = this.getEnchantmentParts(book)) != null) {
                    for (int i = 0; i < enchantments.size(); ++i) {
                        probeInfo.horizontal().padding(30, 4).text(enchantments.get(i));
                    }
                }
            }
            return;
        }
        Block shelf = blockState.getBlock();
        if (shelf instanceof ToolRack) {
            int slot;
            ToolRack block = (ToolRack)shelf;
            ToolRackBlockEntity rack = (ToolRackBlockEntity)level.getBlockEntity(probeHitData.getPos());
            if (rack != null) {
                slot = ToolRack.getToolRackSlot(block, new BlockHitResult(probeHitData.getHitVec(), ((Direction)blockState.getValue((Property)PotionShelf.FACING)).getOpposite(), probeHitData.getPos(), true));
            } else {
                rack = (ToolRackBlockEntity)level.getBlockEntity(probeHitData.getPos().above());
                slot = ToolRack.getToolRackSlot(block, new BlockHitResult(probeHitData.getHitVec(), ((Direction)blockState.getValue((Property)PotionShelf.FACING)).getOpposite(), probeHitData.getPos().above(), true));
            }
            ItemStack tool = rack.GetItem(slot);
            if (slot >= 0 && !tool.isEmpty()) {
                List<Component> enchantments;
                probeInfo.horizontal().item(tool).vertical().padding(2, 4).itemLabel(tool);
                if (ClientConfig.detailedWailaInfoForEnchantedTools && (enchantments = this.getEnchantmentParts(tool)) != null) {
                    for (int i = 0; i < enchantments.size(); ++i) {
                        probeInfo.horizontal().padding(30, 4).text(enchantments.get(i));
                    }
                }
            }
        }
    }
}

