/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;

public class BasicBlockEntity
extends BlockEntity {
    public BasicBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveInternal(tag, registries);
    }

    protected CompoundTag saveInternal(CompoundTag compoundTag, HolderLookup.Provider lookupProvider) {
        return compoundTag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadWithComponents(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveInternal(new CompoundTag(), lookupProvider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void sendUpdated() {
        BasicBlockEntity.sendUpdated(this.getLevel(), this.getBlockPos());
    }

    public static void sendUpdated(@Nullable Level level, BlockPos pos) {
        ChunkSource chunkSource;
        if (level != null && (chunkSource = level.getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache scc = (ServerChunkCache)chunkSource;
            scc.blockChanged(pos);
        }
    }
}

