/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data;

import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.BasicBlockEntity;
import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.TaskListBlockEntity;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.TaskListItem;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.BlockCheckmarkMessage;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.BlockPagingMessage;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListComponent;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListMessaging;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskPageMessage;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class TaskListMessageHandler {
    public static void handleItemMessage(TaskPageMessage message, IPayloadContext context) {
        try {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                TaskListMessageHandler.findAndUpdateItemStack(sp, message.value(), message.extra());
            }
        }
        catch (Exception e) {
            context.disconnect((Component)Component.literal((String)("Networking error in WFHA mod, msg654:  \n" + e.getMessage())));
        }
    }

    private static void findAndUpdateItemStack(ServerPlayer sp, TaskListMessaging.TaskPageDTO value, TaskListMessaging.TaskListExtraDTO extra) {
        ItemStack itemStack = ItemStack.EMPTY;
        TaskListBlockEntity tile = null;
        if (!extra.listIsInBlock()) {
            itemStack = extra.mainHand() ? sp.getMainHandItem() : sp.getOffhandItem();
        } else {
            BlockEntity blockEntity = sp.level().getBlockEntity(extra.tilePos());
            if (blockEntity instanceof TaskListBlockEntity) {
                TaskListBlockEntity tileValue = (TaskListBlockEntity)blockEntity;
                itemStack = tileValue.getItem();
                tile = tileValue;
            }
        }
        if (!itemStack.is(TaskListItem.Utility.ourItem())) {
            sp.displayClientMessage((Component)Component.literal((String)"error: didn't find task list."), false);
            return;
        }
        TaskListMessageHandler.updateItemStack(itemStack, value, extra);
        if (extra.listIsInBlock() && tile != null) {
            tile.setItem(itemStack);
            BasicBlockEntity.sendUpdated(sp.level(), extra.tilePos());
        }
    }

    private static void updateItemStack(ItemStack itemStack, TaskListMessaging.TaskPageDTO value, TaskListMessaging.TaskListExtraDTO extra) {
        TaskListComponent updated;
        int pageNumber = value.pageNumber();
        TaskListComponent old = (TaskListComponent)itemStack.get(TaskListItem.Utility.ourComponent());
        if (old != null) {
            updated = old.makeCopy(value.pageNumber(), extra.lastPage());
        } else {
            updated = new TaskListComponent(1, 1, null);
            pageNumber = 1;
        }
        updated.updatePage(pageNumber, value);
        updated.setLastPage(pageNumber);
        itemStack.set(TaskListItem.Utility.ourComponent(), (Object)updated);
        TaskListItem.Utility.setTitle(itemStack, extra.itemName());
    }

    public static void handleBlockPagingMessage(BlockPagingMessage message, IPayloadContext payloadContext) {
        try {
            ServerPlayer sp;
            BlockEntity blockEntity;
            Player player = payloadContext.player();
            if (player instanceof ServerPlayer && (blockEntity = (sp = (ServerPlayer)player).level().getBlockEntity(message.pos())) instanceof TaskListBlockEntity) {
                TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity;
                if (message.movingRight()) {
                    tile.onArrowNext();
                } else {
                    tile.onArrowPrev();
                }
            }
        }
        catch (Exception e) {
            payloadContext.disconnect((Component)Component.literal((String)("Networking error in WFHA mod, msg656:  \n" + e.getMessage())));
        }
    }

    public static void handleBlockCheckmarkMessage(BlockCheckmarkMessage message, IPayloadContext payloadContext) {
        try {
            ServerPlayer sp;
            BlockEntity blockEntity;
            Player player = payloadContext.player();
            if (player instanceof ServerPlayer && (blockEntity = (sp = (ServerPlayer)player).level().getBlockEntity(message.pos())) instanceof TaskListBlockEntity) {
                TaskListBlockEntity tile = (TaskListBlockEntity)blockEntity;
                tile.updateCheckmark(message.index(), message.pageNumber());
            }
        }
        catch (Exception e) {
            payloadContext.disconnect((Component)Component.literal((String)("Networking error in WFHA mod, msg657:  \n" + e.getMessage())));
        }
    }
}

