/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data;

import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListMessaging;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record TaskPageMessage(TaskListMessaging.TaskPageDTO value, TaskListMessaging.TaskListExtraDTO extra) implements CustomPacketPayload
{
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"message_task_page");
    public static final CustomPacketPayload.Type<TaskPageMessage> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, TaskPageMessage> STREAM_CODEC = StreamCodec.of(TaskPageMessage::encode, TaskPageMessage::decode);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static void encode(RegistryFriendlyByteBuf buf, TaskPageMessage msg) {
        buf.writeInt(msg.value.pageNumber());
        for (int i = 0; i < 6; ++i) {
            buf.writeUtf(msg.value.items().get(i).status());
            buf.writeUtf(msg.value.items().get(i).line1());
            buf.writeUtf(msg.value.items().get(i).line2());
        }
        buf.writeBoolean(msg.extra.mainHand());
        buf.writeInt(msg.extra.lastPage());
        buf.writeUtf(msg.extra.itemName());
        buf.writeBoolean(msg.extra.listIsInBlock());
        buf.writeBlockPos(msg.extra.tilePos());
    }

    @NotNull
    private static TaskPageMessage decode(RegistryFriendlyByteBuf buf) {
        int pageNumber = buf.readInt();
        ArrayList<TaskListMessaging.TaskItemDTO> items = new ArrayList<TaskListMessaging.TaskItemDTO>(6);
        for (int i = 0; i < 6; ++i) {
            String s = TaskPageMessage.silentRead((FriendlyByteBuf)buf);
            String l1 = TaskPageMessage.silentRead((FriendlyByteBuf)buf);
            String l2 = TaskPageMessage.silentRead((FriendlyByteBuf)buf);
            items.add(new TaskListMessaging.TaskItemDTO(s, l1, l2));
        }
        TaskListMessaging.TaskPageDTO page = new TaskListMessaging.TaskPageDTO(pageNumber, items);
        boolean mainHand = buf.readBoolean();
        int lastPage = buf.readInt();
        String itemName = buf.readUtf();
        boolean inBlock = buf.readBoolean();
        BlockPos pos = buf.readBlockPos();
        TaskListMessaging.TaskListExtraDTO extra = new TaskListMessaging.TaskListExtraDTO(mainHand, lastPage, itemName, pos, inBlock);
        return new TaskPageMessage(page, extra);
    }

    private static String silentRead(FriendlyByteBuf buf) {
        try {
            return buf.readUtf();
        }
        catch (DecoderException e) {
            return "???";
        }
    }
}

